/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JRubyContext
implements ScriptContext {
    private ScriptingContainer container;
    private final List<Integer> scopeList;
    private SimpleBindings globalMap = null;
    private JRubyBindings engineMap;

    JRubyContext(ScriptingContainer container) {
        this.container = container;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Scope scope : Scope.values()) {
            list.add(scope.getPriority());
        }
        this.scopeList = Collections.unmodifiableList(list);
        this.engineMap = new JRubyBindings(container);
    }

    private void checkName(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name is empty");
        }
    }

    @Override
    public Object getAttribute(String name) {
        Object ret = null;
        for (Scope scope : Scope.values()) {
            ret = this.getAttributeFromScope(scope.getPriority(), name);
            if (ret == null) continue;
            return ret;
        }
        return ret;
    }

    private Object getAttributeFromScope(int priority, String name) {
        this.checkName(name);
        if (priority == Scope.ENGINE.getPriority()) {
            return this.engineMap.get(name);
        }
        if (priority == Scope.GLOBAL.getPriority()) {
            if (this.globalMap == null) {
                return null;
            }
            return this.globalMap.get(name);
        }
        throw new IllegalArgumentException("invalid scope");
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.getAttributeFromScope(scope, name);
    }

    @Override
    public int getAttributesScope(String name) {
        for (Scope scope : Scope.values()) {
            Object ret = this.getAttributeFromScope(scope.getPriority(), name);
            if (ret == null) continue;
            return scope.getPriority();
        }
        return -1;
    }

    @Override
    public Bindings getBindings(int priority) {
        if (priority == Scope.ENGINE.getPriority()) {
            return this.engineMap;
        }
        if (priority == Scope.GLOBAL.getPriority()) {
            return this.globalMap;
        }
        throw new IllegalArgumentException("invalid scope");
    }

    @Override
    public Writer getErrorWriter() {
        return this.container.getErrorWriter();
    }

    @Override
    public Reader getReader() {
        return this.container.getReader();
    }

    @Override
    public List<Integer> getScopes() {
        return this.scopeList;
    }

    @Override
    public Writer getWriter() {
        return this.container.getWriter();
    }

    @Override
    public Object removeAttribute(String name, int priority) {
        this.checkName(name);
        Bindings bindings = this.getBindings(priority);
        if (bindings == null) {
            return null;
        }
        return bindings.remove(name);
    }

    @Override
    public void setAttribute(String key, Object value, int priority) {
        Bindings bindings = this.getBindings(priority);
        if (bindings == null) {
            return;
        }
        bindings.put(key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBindings(Bindings bindings, int scope) {
        if (scope == Scope.ENGINE.getPriority() && bindings == null) {
            throw new NullPointerException("null bindings in ENGINE scope");
        }
        if (scope == Scope.ENGINE.getPriority()) {
            if (bindings instanceof JRubyBindings) {
                this.engineMap = (JRubyBindings)bindings;
                return;
            } else {
                JRubyBindings b = new JRubyBindings(this.container);
                this.container.setAttribute("org.jruby.embed.jsr223.backed_bindings", bindings);
                Set s = bindings.entrySet();
                for (Map.Entry m : s) {
                    String key = (String)m.getKey();
                    Object value = m.getValue();
                    b.put(key, value);
                }
                this.engineMap = b;
            }
            return;
        } else {
            if (scope != Scope.GLOBAL.getPriority()) throw new IllegalArgumentException("invalid scope");
            if (bindings instanceof SimpleBindings) {
                this.globalMap = (SimpleBindings)bindings;
                return;
            } else {
                if (bindings != null) throw new IllegalArgumentException("invalid bindings");
                this.globalMap = null;
            }
        }
    }

    @Override
    public void setErrorWriter(Writer errorWriter) {
        if (errorWriter == null) {
            return;
        }
        if (this.getErrorWriter() == errorWriter) {
            return;
        }
        this.container.setErrorWriter(errorWriter);
    }

    @Override
    public void setReader(Reader reader) {
        if (reader == null) {
            return;
        }
        if (this.getReader() == reader) {
            return;
        }
        this.container.setReader(reader);
    }

    @Override
    public void setWriter(Writer writer) {
        if (writer == null) {
            return;
        }
        if (this.getWriter() == writer) {
            return;
        }
        this.container.setWriter(writer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Scope {
        ENGINE(100),
        GLOBAL(200);

        private final int priority;

        private Scope(int priority) {
            this.priority = priority;
        }

        int getPriority() {
            return this.priority;
        }
    }
}

