/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyEngine;
import org.jruby.embed.util.SystemPropertyCatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyEngineFactory
implements ScriptEngineFactory {
    private static final String jsr223Props = "org/jruby/embed/jsr223/Jsr223JRubyEngine.properties";
    private final ScriptingContainer container;
    private final String engineName;
    private final String engineVersion;
    private final List<String> extensions;
    private final String languageName;
    private final String languageVersion;
    private final List<String> mimeTypes;
    private final List<String> engineIds;
    private final Map<String, Object> parameters;

    public JRubyEngineFactory() {
        LocalContextScope scope = SystemPropertyCatcher.getScope(LocalContextScope.THREADSAFE);
        LocalVariableBehavior behavior = SystemPropertyCatcher.getBehavior(LocalVariableBehavior.GLOBAL);
        this.container = new ScriptingContainer(scope, behavior, jsr223Props);
        SystemPropertyCatcher.setConfiguration(this.container);
        this.engineName = this.getSingleValue("engine.name").trim();
        this.engineVersion = this.getSingleValue("engine.version").trim();
        this.extensions = Collections.unmodifiableList(this.getMultipleValue("language.extension"));
        this.languageName = this.getSingleValue("language.name").trim();
        this.languageVersion = this.container.getSupportedRubyVersion();
        this.mimeTypes = Collections.unmodifiableList(this.getMultipleValue("language.mimetypes"));
        this.engineIds = Collections.unmodifiableList(this.getMultipleValue("engine.ids"));
        this.parameters = this.getParameters();
    }

    private String getSingleValue(String key) {
        String[] array = this.container.getProperty(key);
        if (array == null) {
            throw new NullPointerException(key + "is not defined");
        }
        return array[0];
    }

    private List getMultipleValue(String key) {
        String[] array = this.container.getProperty(key);
        if (array == null) {
            throw new NullPointerException(key + "is not defined");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : array) {
            list.add(s);
        }
        return list;
    }

    private Map<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("javax.script.engine", this.getEngineName());
        map.put("javax.script.engine_version", this.getEngineVersion());
        map.put("javax.script.name", this.getEngineName());
        map.put("javax.script.language", this.getLanguageName());
        map.put("javax.script.language_version", this.getLanguageVersion());
        map.put("THREADING", "THREAD-ISOLATED");
        return map;
    }

    @Override
    public String getEngineName() {
        return this.engineName;
    }

    @Override
    public String getEngineVersion() {
        return this.engineVersion;
    }

    public List getExtensions() {
        return this.extensions;
    }

    @Override
    public String getLanguageName() {
        return this.languageName;
    }

    @Override
    public String getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public String getMethodCallSyntax(String obj, String m, String ... args) {
        if (m == null || m.length() == 0) {
            return "";
        }
        if (args == null || args.length == 0) {
            if (obj == null || obj.length() == 0) {
                return MessageFormat.format("{0}", m);
            }
            return MessageFormat.format("{0}.{1}", obj, m);
        }
        String argsString = "";
        for (String arg : args) {
            argsString = argsString + arg + ", ";
        }
        argsString = argsString.substring(0, argsString.length() - 2);
        if (obj == null || obj.length() == 0) {
            return MessageFormat.format("{0}({1})", m, argsString);
        }
        return MessageFormat.format("{0}.{1}({2})", obj, m, argsString);
    }

    public List getMimeTypes() {
        return this.mimeTypes;
    }

    public List getNames() {
        return this.engineIds;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        if (toDisplay == null || toDisplay.length() == 0) {
            return "";
        }
        return "puts " + toDisplay + "\nor\nprint " + toDisplay;
    }

    @Override
    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    @Override
    public String getProgram(String ... statements) {
        if (statements == null || statements.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String s : statements) {
            sb.append(s);
            sb.append("\n");
        }
        return new String(sb);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        JRubyEngine engine = new JRubyEngine(this.container, this);
        return engine;
    }
}

