/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.embed.BiVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

abstract class AbstractVariable
implements BiVariable {
    protected String name;
    protected Object javaObject = null;
    protected Class javaType = null;
    protected IRubyObject irubyObject = null;

    protected AbstractVariable(Ruby runtime, String name, Object ... values) {
        this.name = name;
        this.updateJavaObject(runtime, values[0]);
        if (values.length > 1) {
            this.javaType = (Class)values[1];
        } else if (this.javaObject != null) {
            this.javaType = values[0].getClass();
        }
    }

    protected void updateJavaObject(Ruby runtime, Object javaObject) {
        this.javaObject = javaObject;
        this.irubyObject = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)javaObject);
    }

    protected AbstractVariable(String name, IRubyObject rubyObject) {
        this.name = name;
        this.updateRubyObject(rubyObject);
    }

    protected void updateRubyObject(IRubyObject rubyObject) {
        if (rubyObject == null) {
            return;
        }
        this.irubyObject = rubyObject;
        Ruby rt = rubyObject.getRuntime();
        if (this.javaType != null) {
            this.javaObject = this.javaType.cast(JavaEmbedUtils.rubyToJava((Ruby)rt, (IRubyObject)rubyObject, (Class)this.javaType));
        } else {
            this.javaObject = JavaEmbedUtils.rubyToJava((IRubyObject)rubyObject);
            if (this.javaObject != null) {
                this.javaType = this.javaObject.getClass();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Object getJavaObject() {
        return this.javaObject;
    }

    public void setJavaObject(Ruby runtime, Object javaObject) {
        this.updateJavaObject(runtime, javaObject);
    }

    public IRubyObject getRubyObject() {
        return this.irubyObject;
    }

    public void setRubyObject(IRubyObject rubyObject) {
        this.updateRubyObject(rubyObject);
    }

    protected RubyModule getRubyClass(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        return rubyClass;
    }
}

