/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jna;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.provider.jna.JNAPointer;
import java.nio.charset.Charset;

final class PointerMemoryIO
extends AbstractMemoryIO {
    private final com.sun.jna.Pointer ptr;

    PointerMemoryIO() {
        this(com.sun.jna.Pointer.NULL);
    }

    PointerMemoryIO(com.sun.jna.Pointer ptr) {
        this.ptr = ptr;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PointerMemoryIO)) {
            return false;
        }
        PointerMemoryIO io = (PointerMemoryIO)obj;
        return this.ptr != null ? this.ptr.equals((Object)io.ptr) : this.ptr == io.ptr;
    }

    public int hashCode() {
        return this.ptr != null ? this.ptr.hashCode() : 0;
    }

    Object getNativeMemory() {
        return this.ptr;
    }

    public boolean isNull() {
        return this.ptr == null;
    }

    public byte getByte(long offset) {
        return this.ptr.getByte(offset);
    }

    public short getShort(long offset) {
        return this.ptr.getShort(offset);
    }

    public int getInt(long offset) {
        return this.ptr.getInt(offset);
    }

    public long getLong(long offset) {
        return this.ptr.getLong(offset);
    }

    public float getFloat(long offset) {
        return this.ptr.getFloat(offset);
    }

    public double getDouble(long offset) {
        return this.ptr.getDouble(offset);
    }

    public void putByte(long offset, byte value) {
        this.ptr.setByte(offset, value);
    }

    public void putShort(long offset, short value) {
        this.ptr.setShort(offset, value);
    }

    public void putInt(long offset, int value) {
        this.ptr.setInt(offset, value);
    }

    public void putLong(long offset, long value) {
        this.ptr.setLong(offset, value);
    }

    public void putFloat(long offset, float value) {
        this.ptr.setFloat(offset, value);
    }

    public void putDouble(long offset, double value) {
        this.ptr.setDouble(offset, value);
    }

    public void putPointer(long offset, com.sun.jna.Pointer value) {
        this.ptr.setPointer(offset, value);
    }

    public void get(long offset, byte[] dst, int off, int len) {
        this.ptr.read(offset, dst, off, len);
    }

    public void put(long offset, byte[] dst, int off, int len) {
        this.ptr.write(offset, dst, off, len);
    }

    public void get(long offset, short[] dst, int off, int len) {
        this.ptr.read(offset, dst, off, len);
    }

    public void put(long offset, short[] dst, int off, int len) {
        this.ptr.write(offset, dst, off, len);
    }

    public void get(long offset, int[] dst, int off, int len) {
        this.ptr.read(offset, dst, off, len);
    }

    public void put(long offset, int[] dst, int off, int len) {
        this.ptr.write(offset, dst, off, len);
    }

    public void get(long offset, long[] dst, int off, int len) {
        this.ptr.read(offset, dst, off, len);
    }

    public void put(long offset, long[] dst, int off, int len) {
        this.ptr.write(offset, dst, off, len);
    }

    public void get(long offset, float[] dst, int off, int len) {
        this.ptr.read(offset, dst, off, len);
    }

    public void put(long offset, float[] dst, int off, int len) {
        this.ptr.write(offset, dst, off, len);
    }

    public void get(long offset, double[] dst, int off, int len) {
        this.ptr.read(offset, dst, off, len);
    }

    public void put(long offset, double[] dst, int off, int len) {
        this.ptr.write(offset, dst, off, len);
    }

    public int indexOf(long offset, byte value) {
        return (int)this.ptr.indexOf(offset, value);
    }

    public int indexOf(long offset, byte value, int maxlen) {
        return (int)this.ptr.indexOf(offset, value);
    }

    public PointerMemoryIO getMemoryIO(long offset) {
        return new PointerMemoryIO(this.ptr.getPointer(offset));
    }

    public MemoryIO getMemoryIO(long offset, long size) {
        return new PointerMemoryIO(this.ptr.getPointer(offset));
    }

    public boolean isDirect() {
        return true;
    }

    public long getAddress() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Pointer getPointer(long offset) {
        return new JNAPointer(this.ptr.getPointer(offset));
    }

    public void putPointer(long offset, Pointer value) {
        this.ptr.setPointer(offset, ((JNAPointer)value).getNativePointer());
    }

    public String getString(long offset) {
        return this.ptr.getString(offset);
    }

    public String getString(long offset, int maxLength, Charset cs) {
        return this.ptr.getString(offset);
    }

    public void putString(long offset, String string, int maxLength, Charset cs) {
        this.ptr.setString(offset, string);
    }

    public void setMemory(long offset, long size, byte value) {
        this.ptr.setMemory(offset, size, value);
    }
}

