/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental;

import java.util.HashSet;
import java.util.LinkedList;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphTests<V, E> {
    private GraphTests() {
    }

    public static <V, E> boolean isEmpty(Graph<V, E> graph) {
        return graph.edgeSet().isEmpty();
    }

    public static <V, E> boolean isComplete(Graph<V, E> graph) {
        int n = graph.vertexSet().size();
        return graph.edgeSet().size() == n * (n - 1) / 2;
    }

    public static <V, E> boolean isConnected(Graph<V, E> graph) {
        int n = graph.vertexSet().size();
        int n2 = graph.edgeSet().size();
        if (n2 < n - 1) {
            return false;
        }
        if (n < 2 || n2 > (n - 1) * (n - 2) / 2) {
            return true;
        }
        HashSet<V> hashSet = new HashSet<V>();
        LinkedList<V> linkedList = new LinkedList<V>();
        Object object2 = graph.vertexSet().iterator().next();
        linkedList.add(object2);
        hashSet.add(object2);
        while (!linkedList.isEmpty()) {
            object2 = linkedList.removeFirst();
            for (Object object2 : Graphs.neighborListOf(graph, object2)) {
                if (hashSet.contains(object2)) continue;
                hashSet.add(object2);
                linkedList.add(object2);
            }
        }
        return hashSet.size() == n;
    }

    public static <V, E> boolean isTree(Graph<V, E> graph) {
        return GraphTests.isConnected(graph) && graph.edgeSet().size() == graph.vertexSet().size() - 1;
    }

    public static <V, E> boolean isBipartite(Graph<V, E> graph) {
        if (4 * graph.edgeSet().size() > graph.vertexSet().size() * graph.vertexSet().size()) {
            return false;
        }
        if (GraphTests.isEmpty(graph)) {
            return true;
        }
        HashSet<V> hashSet = new HashSet<V>(graph.vertexSet());
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object e = hashSet.iterator().next();
        HashSet<V> hashSet2 = new HashSet<V>();
        linkedList.add(e);
        while (!hashSet.isEmpty()) {
            if (linkedList.isEmpty()) {
                linkedList.add(hashSet.iterator().next());
            }
            e = linkedList.removeFirst();
            hashSet.remove(e);
            for (V v : Graphs.neighborListOf(graph, e)) {
                if (hashSet.contains(v)) {
                    linkedList.add(v);
                    if (hashSet2.contains(e)) continue;
                    hashSet2.add(v);
                    continue;
                }
                if (hashSet2.contains(e) ^ hashSet2.contains(v)) continue;
                return false;
            }
        }
        return true;
    }
}

