/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.beans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.dynalang.mop.CallProtocol;
import org.dynalang.mop.beans.DynamicMethod;
import org.dynalang.mop.beans.Invocation;
import org.dynalang.mop.beans.OverloadedFixArgMethod;
import org.dynalang.mop.beans.OverloadedVarArgMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OverloadedDynamicMethod<T extends Member>
extends DynamicMethod {
    static final Object NO_SUCH_METHOD = new Object();
    static final Object AMBIGUOUS_METHOD = new Object();
    private final OverloadedFixArgMethod<T> fixArgMethod = new OverloadedFixArgMethod();
    private final String name;
    private OverloadedVarArgMethod<T> varArgMethod;

    OverloadedDynamicMethod(String name) {
        this.name = name;
    }

    @Override
    Object call(Object target, Object[] args, CallProtocol callProtocol) {
        Object invocation = this.fixArgMethod.createInvocation(target, args, callProtocol);
        if (invocation == NO_SUCH_METHOD) {
            if (this.varArgMethod != null) {
                invocation = this.varArgMethod.createInvocation(target, args, callProtocol);
            }
            if (invocation == NO_SUCH_METHOD) {
                throw new IllegalArgumentException("No signature of method " + this.name + " on " + OverloadedDynamicMethod.getClassName(target) + " match the arguments");
            }
        }
        if (invocation == AMBIGUOUS_METHOD) {
            throw new IllegalArgumentException("Multiple signatures of method " + this.name + " on " + OverloadedDynamicMethod.getClassName(target) + " match the arguments");
        }
        try {
            return ((Invocation)invocation).invoke();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static String getClassName(Object obj) {
        return obj == null ? "null" : obj.getClass().getName();
    }

    void addMember(T member) {
        boolean isVarArg;
        this.fixArgMethod.addMember(member);
        if (member instanceof Method) {
            isVarArg = ((Method)member).isVarArgs();
        } else if (member instanceof Constructor) {
            isVarArg = ((Constructor)member).isVarArgs();
        } else {
            throw new AssertionError();
        }
        if (isVarArg) {
            if (this.varArgMethod == null) {
                this.varArgMethod = new OverloadedVarArgMethod();
            }
            this.varArgMethod.addMember(member);
        }
    }
}

