/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.structures.AbstractStructureWithAttributes;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.ClassMember;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantLargeNumeric;

public class BrowserTreePane
extends JPanel {
    private static final Dimension treeMinimumSize = new Dimension(100, 150);
    private static final Dimension treePreferredSize = new Dimension(250, 150);
    private BrowserServices services;
    private JTree tree;
    private Map categoryToPath = new HashMap();

    public BrowserTreePane(BrowserServices browserServices) {
        this.services = browserServices;
        this.setLayout(new BorderLayout());
        this.setupComponent();
    }

    public JTree getTree() {
        return this.tree;
    }

    public TreePath getPathForCategory(String string) {
        return (TreePath)this.categoryToPath.get(string);
    }

    public void rebuild() {
        this.categoryToPath.clear();
        this.tree.clearSelection();
        this.tree.setModel(this.buildTreeModel());
    }

    private void setupComponent() {
        JScrollPane jScrollPane = new JScrollPane(this.buildTree());
        jScrollPane.setMinimumSize(treeMinimumSize);
        jScrollPane.setPreferredSize(treePreferredSize);
        this.add((Component)jScrollPane, "Center");
    }

    private JTree buildTree() {
        this.tree = new JTree(this.buildTreeModel());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        return this.tree;
    }

    private TreeModel buildTreeModel() {
        BrowserTreeNode browserTreeNode = this.buildRootNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(browserTreeNode);
        return defaultTreeModel;
    }

    private BrowserTreeNode buildRootNode() {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode("Class file");
        ClassFile classFile = this.services.getClassFile();
        if (classFile != null) {
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode("General Information", "general");
            BrowserTreeNode browserTreeNode3 = this.buildConstantPoolNode();
            BrowserTreeNode browserTreeNode4 = this.buildInterfacesNode();
            BrowserTreeNode browserTreeNode5 = this.buildFieldsNode();
            BrowserTreeNode browserTreeNode6 = this.buildMethodsNode();
            BrowserTreeNode browserTreeNode7 = this.buildAttributesNode();
            browserTreeNode.add(browserTreeNode2);
            browserTreeNode.add(browserTreeNode3);
            browserTreeNode.add(browserTreeNode4);
            browserTreeNode.add(browserTreeNode5);
            browserTreeNode.add(browserTreeNode6);
            browserTreeNode.add(browserTreeNode7);
            this.categoryToPath.put("general", new TreePath(new Object[]{browserTreeNode, browserTreeNode2}));
            this.categoryToPath.put("constantPool", new TreePath(new Object[]{browserTreeNode, browserTreeNode3}));
            this.categoryToPath.put("interface", new TreePath(new Object[]{browserTreeNode, browserTreeNode4}));
            this.categoryToPath.put("field", new TreePath(new Object[]{browserTreeNode, browserTreeNode5}));
            this.categoryToPath.put("method", new TreePath(new Object[]{browserTreeNode, browserTreeNode6}));
            this.categoryToPath.put("attribute", new TreePath(new Object[]{browserTreeNode, browserTreeNode7}));
        }
        return browserTreeNode;
    }

    private BrowserTreeNode buildConstantPoolNode() {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode("Constant Pool");
        CPInfo[] cPInfoArray = this.services.getClassFile().getConstantPool();
        int n = cPInfoArray.length;
        int n2 = 1;
        while (n2 < n) {
            n2 += this.addConstantPoolEntry(cPInfoArray[n2], n2, n, browserTreeNode);
            ++n2;
        }
        return browserTreeNode;
    }

    private int addConstantPoolEntry(CPInfo cPInfo, int n, int n2, BrowserTreeNode browserTreeNode) {
        if (cPInfo == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + cPInfo.getTagVerbose(), "constantPool", n);
            browserTreeNode.add(browserTreeNode2);
            if (cPInfo instanceof ConstantLargeNumeric) {
                this.addConstantPoolContinuedEntry(n + 1, n2, browserTreeNode);
                return 1;
            }
        }
        return 0;
    }

    private void addConstantPoolContinuedEntry(int n, int n2, BrowserTreeNode browserTreeNode) {
        BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + "(large numeric continued)", "noContent");
        browserTreeNode.add(browserTreeNode2);
    }

    private BrowserTreeNode buildInterfacesNode() {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode("Interfaces");
        int[] nArray = this.services.getClassFile().getInterfaces();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            BrowserTreeNode browserTreeNode2 = new BrowserTreeNode("Interface " + n2, "interface", n2);
            browserTreeNode.add(browserTreeNode2);
            ++n2;
        }
        return browserTreeNode;
    }

    private BrowserTreeNode buildFieldsNode() {
        return this.buildClassMembersNode("Fields", "field", this.services.getClassFile().getFields());
    }

    private BrowserTreeNode buildMethodsNode() {
        return this.buildClassMembersNode("Methods", "method", this.services.getClassFile().getMethods());
    }

    private BrowserTreeNode buildClassMembersNode(String string, String string2, ClassMember[] classMemberArray) {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode(string);
        int n = classMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addClassMembersNode(classMemberArray[n2], n2, n, string2, browserTreeNode);
            ++n2;
        }
        return browserTreeNode;
    }

    private void addClassMembersNode(ClassMember classMember, int n, int n2, String string, BrowserTreeNode browserTreeNode) {
        if (classMember == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            try {
                BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + classMember.getName(), string, n);
                browserTreeNode.add(browserTreeNode2);
                this.addAttributeNodes(browserTreeNode2, classMember);
            }
            catch (InvalidByteCodeException invalidByteCodeException) {
                browserTreeNode.add(this.buildNullNode());
            }
        }
    }

    private BrowserTreeNode buildAttributesNode() {
        BrowserTreeNode browserTreeNode = new BrowserTreeNode("Attributes");
        this.addAttributeNodes(browserTreeNode, this.services.getClassFile());
        return browserTreeNode;
    }

    private BrowserTreeNode buildNullNode() {
        return new BrowserTreeNode("[error] null");
    }

    private void addAttributeNodes(BrowserTreeNode browserTreeNode, AbstractStructureWithAttributes abstractStructureWithAttributes) {
        AttributeInfo[] attributeInfoArray = abstractStructureWithAttributes.getAttributes();
        if (attributeInfoArray == null) {
            return;
        }
        int n = attributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addSingleAttributeNode(attributeInfoArray[n2], n2, n, browserTreeNode);
            ++n2;
        }
    }

    private void addSingleAttributeNode(AttributeInfo attributeInfo, int n, int n2, BrowserTreeNode browserTreeNode) {
        if (attributeInfo == null) {
            browserTreeNode.add(this.buildNullNode());
        } else {
            try {
                BrowserTreeNode browserTreeNode2 = new BrowserTreeNode(this.getFormattedIndex(n, n2) + attributeInfo.getName(), "attribute", n);
                browserTreeNode.add(browserTreeNode2);
                this.addAttributeNodes(browserTreeNode2, attributeInfo);
            }
            catch (InvalidByteCodeException invalidByteCodeException) {
                browserTreeNode.add(this.buildNullNode());
            }
        }
    }

    private String getFormattedIndex(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("[");
        String string = String.valueOf(n);
        String string2 = String.valueOf(n2 - 1);
        int n3 = 0;
        while (n3 < string2.length() - string.length()) {
            stringBuffer.append("0");
            ++n3;
        }
        stringBuffer.append(string);
        stringBuffer.append("]");
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }
}

