/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AbstractStructure;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class ExceptionTableEntry
extends AbstractStructure {
    public static final int LENGTH = 8;
    private int startPc;
    private int endPc;
    private int handlerPc;
    private int catchType;

    public static ExceptionTableEntry create(DataInput dataInput, ClassFile classFile) throws InvalidByteCodeException, IOException {
        ExceptionTableEntry exceptionTableEntry = new ExceptionTableEntry();
        exceptionTableEntry.setClassFile(classFile);
        exceptionTableEntry.read(dataInput);
        return exceptionTableEntry;
    }

    public ExceptionTableEntry() {
    }

    public ExceptionTableEntry(int n, int n2, int n3, int n4) {
        this.startPc = n;
        this.endPc = n2;
        this.handlerPc = n3;
        this.catchType = n4;
    }

    public int getStartPc() {
        return this.startPc;
    }

    public void setStartPc(int n) {
        this.startPc = n;
    }

    public int getEndPc() {
        return this.endPc;
    }

    public void setEndPc(int n) {
        this.endPc = n;
    }

    public int getHandlerPc() {
        return this.handlerPc;
    }

    public void setHandlerPc(int n) {
        this.handlerPc = n;
    }

    public int getCatchType() {
        return this.catchType;
    }

    public void setCatchType(int n) {
        this.catchType = n;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.startPc = dataInput.readUnsignedShort();
        this.endPc = dataInput.readUnsignedShort();
        this.handlerPc = dataInput.readUnsignedShort();
        this.catchType = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        dataOutput.writeShort(this.startPc);
        dataOutput.writeShort(this.endPc);
        dataOutput.writeShort(this.handlerPc);
        dataOutput.writeShort(this.catchType);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + "exception table entry with start_pc " + this.startPc + ", end_pc " + this.endPc + ", handler_pc " + this.handlerPc + ", catch_type index " + this.catchType);
    }
}

