/*********************************************************************
 *
 *      Copyright (C) 1999-2003 Nathan Fiedler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * PROJECT:     JSwat
 * MODULE:      JSwat Requests
 * FILE:        MalformedMemberNameException.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      5/31/99         Initial version
 *
 * $Id: MalformedMemberNameException.java 1048 2003-11-16 07:27:16Z nfiedler $
 *
 ********************************************************************/

package com.bluemarsh.jswat;

/**
 * MalformedMemberNameException is thrown when the user gives an invalid
 * method name.
 *
 * @author  Nathan Fiedler
 */
public class MalformedMemberNameException extends Exception {

    /**
     * Constructs a MalformedMemberNameException with no message.
     */
    public MalformedMemberNameException() {
        super();
    } // MalformedMemberNameException

    /**
     * Constructs a MalformedMemberNameException with the given
     * message.
     *
     * @param  s  Message.
     */
    public MalformedMemberNameException(String s) {
        super(s);
    } // MalformedMemberNameException
} // MalformedMemberNameException
