/**
 * @file   generic_callback.c
 * 
 * <EN>
 * @brief  An example plugin using callback.
 * </EN>
 * 
 * <JA>
 * @brief  ХåȤץ饰Υץ
 * </JA>
 * 
 * @author Akinobu Lee
 * @date   Wed Aug 13 23:50:27 2008
 * 
 * $Revision: 1.1 $
 * 
 */

/**
 * Required for a file
 *   - get_plugin_info()
 *
 * Optional for a file
 *   - initialize()
 * 
 */
/**
 * using plugin function:
 * 
 *   - engine_startup()
 * 
 */


// #include "plugin_defs.h"
#include <julius/juliuslib.h>

#define PLUGIN_TITLE "An example plugin using callback"

/** 
 * <EN>
 * @brief  Initialization at loading time (optional)
 * 
 * If defined, this will be called just before this plugin is loaded to Julius.
 * if this returns -1, the whole functions in this file will not be loaded.
 *
 * This function is OPTIONAL.
 * </EN>
 * <JA>
 * @brief  ɤ߹߻νǤա
 *
 * ưJulius Υץ饰ɤ߹ݤ˺ǽ˸ƤФ롥
 * -1 ֤ȡΥץ饰Τɤ߹ޤʤʤ롥
 * ¹ԲǽΥå˻Ȥ롥
 *
 * </JA>
 * 
 * 
 * @return 0 on success, -1 on failure.
 * 
 */
int
initialize()
{
  return 0;
}

/** 
 * <EN>
 * @brief  Get information of this plugin (required)
 *
 * This function should return informations of this plugin file.
 * The required info will be specified by opcode:
 *  - 0: return description string of this file into buf
 *
 * This will be called just after Julius find this file and after
 * initialize().
 *
 * @param opcode [in] requested operation code
 * @param buf [out] buffer to store the return string
 * @param buflen [in] maximum length of buf
 *
 * @return 0 on success, -1 on failure.  On failure, Julius will ignore this
 * plugin.
 * 
 * </EN>
 * <JA>
 * @brief  ץ饰ɬܡ
 *
 * Υץ饰˴ؤ֤Ϳ줿 opcode ˤäư롥
 *  - 0 ξ硤Υץ饰ե̾ΤͿ줿Хåե˳Ǽ
 *
 * δؿϡJulius Υץ饰ɤ߹ľ˸ƤФ롥
 * 
 * @param opcode [in] ׵ư ( 0 Τ߼)
 * @param buf [out] ͤǼХåե
 * @param buflen [in] buf κĹ
 * 
 * @return 顼 -1,  0 ֤顼Ȥ -1 ֤硤
 * Υץ饰Τɤ߹ޤʤ
 * </JA>
 * 
 */
int
get_plugin_info(int opcode, char *buf, int buflen)
{
  switch(opcode) {
  case 0:
    /* plugin description string */
    strncpy(buf, PLUGIN_TITLE, buflen);
    break;
  }

  return 0;
}

/** 
 * <EN>
 * A sample callback function to output RECREADY message.
 * 
 * @param recog [in] engine instance
 * @param dummy [in] callback argument (dummy)
 * </EN>
 * <JA>
 * RECREADY Ϥ륳ХåѴؿʥץ
 *
 * @param recog [in] 󥸥󥤥󥹥
 * @param dummy [in] Хåʥߡ
 * </JA>
 * 
 */
static void
status_recready(Recog *recog, void *dummy)
{
  printf("<<<RECREADY>>>\n");
}

/** 
 * <EN>
 * @brief  plugin function that will be called after engine startup.
 *
 * When the function of this name is defined in a plugin, this will
 * be called just after Julius finished all startup sequence and before
 * input and recognition start.
 *
 * In this example, this function registers the local function
 * status_recready() as a CALLBACK_EVENT_SPEECH_READY callback.
 * This callback will be called on every time Julius is ready for
 * recognition for the next incoming input.
 * 
 * @param data [in] a data pointer, actually a pointer to an engine instance.
 * 
 * @return 0 on success, -1 on error.  On error, Julius will exit immediately.
 * </EN>
 * <JA>
 * @brief  ǧ󥸥ưλ˸ƤӽФץ饰ؿ
 *
 * ̾δؿ줿硤δؿϡJulius Ƥν
 * λƵưץ򽪤ľ塤ºݤ˲Ϥ򳫤ǧϤ
 * ˸ƤФޤ
 *
 * ǤϡδؿȤäơ嵭δؿ status_recready() 
 * CALLBACK_EVENT_SPEECH_READY ХåȤϿƤޤ
 * ΥХå Julius ϥȥ꡼फμβԤ
 * ֤ˤʤäȤ˸ƤФޤ
 * 
 * @param data [in] ǡؤΥݥ󥿡Τϥ󥸥󥤥󥹥󥹤ؤ
 * ݥ󥿤Ϥ롥
 * 
 * @return  0 顼 -1 ֤顼ξ Julius ϰ۾ｪλ롥
 * </JA>
 * 
 */
int
startup(void *data)
{
  Recog *recog = data;
  callback_add(recog, CALLBACK_EVENT_SPEECH_READY, status_recready, NULL);
  return 0;
}
