/***************************************************************************
 *   Copyright (C) 2003-2004 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KFOLDINGCONFIGDATA_H
#define KFOLDINGCONFIGDATA_H

#include <qstring.h>

/**
@author Kevin Hessels
*/

class KConfig;

class kfoldingConfigData
{

public:
	enum ModelType
	{
		SpaceFilling = 0,
		WireFrame,
		BallandStick,
		AlphaCarbonTrace
	};
	
	enum DisplayType
	{
		Normal = 0,
		StereoLR,
		StereoRL
	};


	kfoldingConfigData( KConfig* config );
	kfoldingConfigData( const kfoldingConfigData& );
	~kfoldingConfigData();
    
	kfoldingConfigData const &operator=( kfoldingConfigData const& );
	
	KConfig* kconfig() { return _cfg; }
	
	bool load();
	bool save();
	
	bool firstRun() const { return _firstRun; }
	
	QString executable() const { return _executable; }
	void setExecutable( const QString& value ) { _executable = value; }
	
	QString workingDir() const { return _workingDir; }
	void setWorkingDir( const QString& value ) { _workingDir = value; }
	
	QString appletImage() const { return _appletImage; }
	void setAppletImage( const QString& value ) { _appletImage = value; }
	
	int state() const { return _state; }
	void setState( int value ) { _state = value; }
	
	int lastPid() const { return _lastPid; }
	void setLastPid( int value ) { _lastPid = value; }
		
	bool forceASM() const { return _forceasm; }
	void setForceASM( bool value ) { _forceasm = value; }
	
	bool bigPackets() const { return _bigPackets; }
	void setBigPackets( bool value ) { _bigPackets = value; }
	
	bool useAdvMethods() const { return _useadvmethods; }
	void setUseAdvMethods( bool value ) { _useadvmethods = value; }
	
	bool startOnLaunch() const { return _startOnLaunch; }
	void setStartOnLaunch( bool value ) { _startOnLaunch = value; }
	
	bool restoreState() const { return _restoreState; }
	void setRestoreState( bool value ) { _restoreState = value; }
	
	QString userName() const { return _userName; }
	void setUserName( const QString& value ) { _userName = value; }
	
	int teamNumber() const { return _teamNumber; }
	void setTeamNumber( int value ) { _teamNumber = value; }
	
	int clientType() const { return _clientType; }
	void setClientType( int value ) { _clientType = value; }
	
	ModelType model() const { return _model; }
	void setModel( ModelType value ) { _model = value; }
	
	DisplayType display() const { return _display; }
	void setDisplay( DisplayType value ) { _display = value; }
	
	int ballSize() const { return _ballSize; }
	void setBallSize( int value ) { _ballSize = value; }
	
	int quality() const { return _quality; }
	void setQuality( int value ) { _quality = value; }
	
	int stereoDepth() const { return _stereoDepth;  }
	void setStereoDepth( int value ) { _stereoDepth = value; }
	
	int machineId() const { return _machineId; }
	void setMachineId( int value ) { _machineId = value; }
	
	bool showH2O() const { return _showH2O; }
	void setShowH2O( bool value ) { _showH2O = value; }
	
	bool showH2() const { return _showH2; }
	void setShowH2( bool value ) { _showH2 = value; }
	
	bool nonBackbone() const { return _nonBackbone; }
	void setNonBackbone( bool value ) { _nonBackbone = value; }
	
private:
	KConfig* 	_cfg;
	
	QString		_executable;
	QString		_workingDir;
	QString		_userName;
	QString		_appletImage;
	int		_state;
	int		_lastPid;
	
	int		_teamNumber;
	int		_clientType;
	ModelType	_model;
	DisplayType	_display;
	int		_ballSize;
	int		_quality;
	int		_stereoDepth;
	int 		_machineId;
	
	bool		_forceasm;
	bool		_bigPackets;
	bool		_useadvmethods;
	bool		_firstRun;
	bool		_startOnLaunch;
	bool		_restoreState;
	bool		_showH2O;
	bool		_showH2;
	bool 		_nonBackbone;
};

#endif
