/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qslider.h>

#include <kcombobox.h>
#include <kdebug.h>
 
#include "kfoldingconfigdata.h"
#include "kfoldingdisplaywidgetimpl.h"


kfoldingDisplayWidgetImpl::kfoldingDisplayWidgetImpl( QWidget *parent, const char* name, kfoldingConfigData *cfg )
 : kfoldingDisplayWidget( parent, name ),
   _configData( cfg )
{
	setupWidgets();

	connect( this->model, SIGNAL( activated( int ) ), this, SLOT( slotModelTypeChanged( int ) ) );
	connect( this->display, SIGNAL( activated( int ) ), this, SLOT( slotDisplayTypeChanged( int ) ) );
	return;
} // kfoldingDisplayWidgetImpl ctor


kfoldingDisplayWidgetImpl::~kfoldingDisplayWidgetImpl()
{
	return;
} // kfoldingDisplayWidgetImpl dtor


void kfoldingDisplayWidgetImpl::saveOptions()
{
	if ( !_configData )
		return;

	_configData->setModel( ( kfoldingConfigData::ModelType )  model->currentItem() );
	_configData->setDisplay(  ( kfoldingConfigData::DisplayType ) display->currentItem() );
	_configData->setQuality( quality->value() );
	_configData->setBallSize( ballSize->value() );
	_configData->setStereoDepth( stereoDepth->value() );
	_configData->setShowH2O( showH2O->isChecked() );
	_configData->setShowH2( showH2->isChecked() );
	_configData->setNonBackbone( nonBackbone->isChecked() );
	
	_configData->save();
	
	slotDisplayTypeChanged( display->currentItem() );
	slotModelTypeChanged( model->currentItem() );
	return;
} // saveOptions



void kfoldingDisplayWidgetImpl::slotDisplayTypeChanged( int index )
{
	if ( index != kfoldingConfigData::Normal ) {
		lblStereoDepth->setEnabled( true );
		stereoDepth->setEnabled( true );
	} else {
		lblStereoDepth->setEnabled( false );
		stereoDepth->setEnabled( false );
	} // else
	return;
} // slotDisplayTypeChanged


void kfoldingDisplayWidgetImpl::slotModelTypeChanged( int index )
{
	if ( index != kfoldingConfigData::BallandStick ) {
		lblBallSize->setEnabled( false );
		ballSize->setEnabled( false );
	} else {
		lblBallSize->setEnabled( true );
		ballSize->setEnabled( true );
	} // else
	return;
} // slotModelTypeChanged



void kfoldingDisplayWidgetImpl::setupWidgets()
{
	if ( !_configData )
		return;
		
	model->setCurrentItem( _configData->model() );
	display->setCurrentItem( _configData->display() );
	quality->setValue( _configData->quality() );
	ballSize->setValue( _configData->ballSize() );
	stereoDepth->setValue( _configData->stereoDepth() );
	showH2O->setChecked( _configData->showH2O() );
	showH2->setChecked( _configData->showH2() );
	nonBackbone->setChecked( _configData->nonBackbone() );
	
	slotDisplayTypeChanged( display->currentItem() );
	slotModelTypeChanged( model->currentItem() );
	return;
} // setupWidgets

#include "kfoldingdisplaywidgetimpl.moc"

