/***************************************************************************
                          mainpainter.cpp  -  description
                             -------------------
    begin                : Fri Jan 4 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mainpainter.h"
#define e_stopped  -98
#define e_finished -99


mainPainter::mainPainter(const configuration *c) {

	conf=c;
	
	ph = new paintHelpers(conf);	
	
	sahdirs=conf->getSahdirs();

	for ( QStringList::Iterator it2 = sahdirs.begin(); it2 != sahdirs.end(); ++it2 ) {
		sahlist.append(new SetiLocation(*it2));
  }
	currSL = sahlist.first();



	//sp.setSetiPath(conf->getSetipath().latin1());
  ph->sound->setEnabled(conf->isPlayaudio());

	//cout << "Starting ... " << endl;
	if (conf->isStartclient()) {
		QProcess *watchdog = new QProcess();
    QString mypid = QString::number(getpid());
		//int pid = ;
		
		watchdog->clearArguments();
		watchdog->addArgument("setiwatchdog");
		watchdog->addArgument(mypid);
		watchdog->addArgument(conf->getSetipath());
		watchdog->addArgument(conf->getDatapath());

		if (conf->isManualTransfer()) {
			watchdog->addArgument("noconnect");
		}
		
		cout << "Starting procs" << endl;

		if (!watchdog->start()) {
   		cout << "returned false! " << endl;
		}
	}

	mode = INIT;
}

mainPainter::~mainPainter(){
   delete ph;
}

int mainPainter::paint(QPainter *p,  QWidget *rpt,  QTimer *timer) {
	//cout << "Mode is  "<< mode << endl;
	int sleep = 1000;
	int cstate;
	//sp.setSetiPath("/home/sebastian/stmp/");
	//mode = TRANSFER;
	//sp.parseSAH();
	switch (mode) {
  	case INIT:
			sleep=500;
			iScreen.paintScreen(p, rpt, QString("Initializing"), ph);
			mode = POSITION;
			break;
		case POSITION:
			sleep=500;
			getNextSahDir();

      int res;
			res = sp.parseSAH();

      currSL->updateProc(sp.getProc());
			cstate = currSL->getState();
			cout << "RETURNED " << cstate << endl;

      if (cstate == currSL->TRANSFER || cstate == currSL->CONNECT) {
			  	mode=TRANSFER;
					break;
			}

      if (cstate == currSL->FINISHED) {
				setErrorMsg(e_finished); 
    				mode=ERROR;
				break;
			}
			
      if (cstate == currSL->STOPPED) {
				setErrorMsg(e_stopped); 
    				mode=ERROR;
				break;
    			}
				
      if (/*cstate == currSL->RUNNING &&*/ res == 0) {
      	posScreen.paintScreen(p, rpt, &sp, ph);
				lastmode=POSITION;
				mode=ACCESS;
				break;
			}
      else {		      
				setErrorMsg(res);
				mode = ERROR;
      	break;	
			}

			
		case GAUSSIAN:
			sleep = 500;
			gScreen.paintScreen(p,rpt,&sp,ph);
			lastmode=GAUSSIAN;
			mode=ACCESS;
			break;
		case PULSE:
			sleep = 500;
			pScreen.paintScreen(p,rpt,ph,sp);
			lastmode=PULSE;
			mode=ACCESS;
			break;
		case TRIPLET:
			sleep = 500;
			tScreen.paintScreen(p,rpt,&sp,ph);
			lastmode=TRIPLET;
			mode = ACCESS;
			break;
		case INFO:
			sleep=500;
			tiScreen.paintScreen(p,sp,ph);
			lastmode = INFO;
			if (sahdirs.count() == 1) {
				mode = ACCESS;
			}
			else {
       	mode=LOADNEXT;
			}
			break;
		case TRANSFER:
      sleep = 50;
			trScreen.paintScreen(p,ph,currSL);
    	lastmode = INFO; //behave as if this has been the info screen
			if (sahdirs.count() == 1) {
				mode = ACCESS;
			}
			else {
      	mode=LOADNEXT;
			}
			break;  	
		case ACCESS:
			sleep=500;
			iScreen.paintScreen(p, rpt, QString("Accessing"), ph);
			mode=getMode(lastmode);
			break;
		case LOADNEXT:
			sleep=500;
			iScreen.paintScreen(p, rpt, QString("Loading next location"), ph);
			mode=getMode(lastmode);
			break;
		case ERROR:
			eScreen.paintScreen(p, errorMsg, ph);
			mode=INIT;
			break;
		default:
			//Unknow mode, resettng
			mode=INIT;
			sleep=500;
			break;
	}
	//p->flush();
 	return sleep;
}

void mainPainter::setErrorMsg(int nr) {
 switch(nr) {
 	case -11:
		  errorMsg="Unable to locate data "+QString(sp.getSetiPath().c_str())+"/state.sah";
			break;
	case -12:
		  errorMsg="Unable to locate data "+QString(sp.getSetiPath().c_str())+"/user_info.sah";
			break;
	case -13:
			errorMsg="Unable to locate data "+QString(sp.getSetiPath().c_str())+"/work_unit.sah";
			break;
	case -98:	
			errorMsg="No seti@home client running.";
			break;
	case -99:
		        errorMsg="Workunit finished. No new data avaible!"; 
			break;
	default:
			errorMsg="Computer core is suffering from unknown failure: E="+nr;
 }
}

mainPainter::Modes mainPainter::getMode(Modes lm) {
	switch(lm) {
		case POSITION:
			//cout << "Proc "<< sp.getProc() << endl;
			//return POSITION; //DEBUG!
			
			if (sp.getGaussian().valid) {  return GAUSSIAN; }
			if (sp.getPulse().valid)    {  return PULSE; }
			if (sp.getTriplet().valid)    {  return TRIPLET; }
      return INFO;
		case GAUSSIAN:
			if (sp.getPulse().valid)    {  return PULSE; }
			if (sp.getTriplet().valid)    {  return TRIPLET; }
			return INFO;
		case PULSE:
			if (sp.getTriplet().valid)    {  return TRIPLET; }
			return INFO;
		case TRIPLET:
			return INFO;
		case INFO:
			return POSITION;
		default:
			return POSITION;
	}
}

void mainPainter::getNextSahDir() {
	currSL = sahlist.next();
	if (currSL == 0) {
  	currSL = sahlist.first();
	}
	sp.setSetiPath(currSL->getPath().latin1());
	//cout << "Now scanning " << currSL->getPath().latin1() << endl;
}





