/*
 * GXMame
 *
 * Copyright 2002-2004 Stephane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __PROGRESSION_WINDOW_H__
#define __PROGRESSION_WINDOW_H__

typedef void ProgressWindow;

#include "common.h"


ProgressWindow *
progress_window_new(void);

void progress_window_show(void);

void progress_window_destroy(void);

void progress_window_set_title(const gchar *format, ...);

void progress_window_set_text(const gchar *text);

void progress_window_set_value(gfloat current_value);

gboolean progress_window_cancelled(ProgressWindow *progress_window);

#endif /* __PROGRESSION_WINDOW_H__ */
