SYNOPSIS
        varargs int difference(mixed a,mixed b,int max,
                               closure element_difference);

          a, b
              strings or arrays of mixed
          max                     (optional, defaults to MAX_INT)
              the maximal number of differences on which to abort
          element_difference      (optional, defaults to !(x == y) )
              closure receiving two elements of a and b and returning
              an int which states the difference between the two
              elements

DESCRIPTION
        The function returns the number of differences between the two
        given values a and b.  As a difference counts one of the
        following:
        - a different element              (e.g. "blah", "bloh")
        - a missing element                (e.g. "blah", "blh")
        - an extra element                 (e.g. "blah", "blaah")
        - two swapped consecutive elements (e.g. "blah", "balh")

        The optional third argument (max) states a maximal number of
        differences up to which the algorithm shall search for the
        solution; if the result would be greater than this given number
        the search will be aborted and this value (max) is returned.

        The optional fourth argument (element_difference) is a closure
        which returns a difference for two single elements of a and b;
        if defaults to 0 for equal and 1 for different elements; thus
        it is possible to react nifty on typos by giving two chars which
        are close together on a keyboard a smaller difference value than
        two chars which are far apart.

EXAMPLE
        difference("bla","bla")
          /* returns 0 */

        difference("bla","blo")
          /* returns 1 (one different character) */

        difference(({ 0,1,2,3 }),({ 0,1,3,7 }))
          /* returns 2 (one pair swapped and one element wrong) */

        difference("abcdefgh","stuvwxyz",5)
          /* returns 5 (8 differences, but max is given as 5) */

        difference(({ "abc","def","dext","jkl" }),
                   ({ "abc","dext","def","jkl" }),
                   100,
                   (#'difference));
          /* returns 1 (one word pair swapped is the least difference
             while the comparison of "def" and "dext" would result 2
             differences (one char different and one char missing), but
             just the smallest possible amount of differences is returned
             as result) */
