/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;
import org.logi.crypto.hash.SHA1State;

public class HashInputStream
extends FilterInputStream {
    private HashState hashState;
    private byte[] oneByte = new byte[1];

    public synchronized Fingerprint getFingerprint() {
        return this.hashState.calculate();
    }

    public synchronized int read() throws IOException {
        int n = this.in.read();
        if (n > 0) {
            this.oneByte[0] = (byte)n;
            this.hashState.update(this.oneByte, 0, 1);
        }
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            this.hashState.update(byArray, n, n3);
        }
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public boolean markSupported() {
        return false;
    }

    public HashInputStream(InputStream inputStream, HashState hashState) {
        super(inputStream);
        this.hashState = hashState;
    }

    public HashInputStream(InputStream inputStream) {
        this(inputStream, new SHA1State());
    }
}

