/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.random;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Spinner
extends Thread {
    private long t;

    public static int spin(long l) {
        int n = 0;
        Spinner spinner = new Spinner(l);
        spinner.start();
        do {
            ++n;
            Thread.yield();
        } while (spinner.isAlive());
        return n;
    }

    public void run() {
        try {
            Thread.sleep(this.t);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static int guessTime(int n) {
        int n2 = 5;
        while (Spinner.spin(n2) < n) {
            n2 = n2 * 3 / 2;
        }
        return n2;
    }

    public static void main(String[] stringArray) throws IOException {
        int n = stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : Spinner.guessTime(1024);
        System.out.println("Using t=" + n);
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("spin." + n));
        int n2 = 0;
        while (n2 < 0x100000) {
            int n3 = Spinner.spin(n);
            dataOutputStream.writeByte(n3);
            if (n2 % 128 == 0) {
                System.out.println(n2 + "\t" + n3);
            }
            ++n2;
        }
        System.out.println(1024);
        dataOutputStream.flush();
    }

    private Spinner(long l) {
        this.t = l;
    }
}

