/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.colorchooser.NumericDocument;

class JIntegerTextField
extends JTextField {
    public JIntegerTextField(int n, int n2, int n3) {
        super(new NumericDocument(n, n2), String.valueOf(n3), String.valueOf(n2).length() + 1);
        this.installKeyboardActions();
    }

    public int getIntegerValue() {
        return ((NumericDocument)this.getDocument()).getIntegerValue();
    }

    protected void installKeyboardActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke("KP_UP");
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke("KP_DOWN");
        this.registerKeyboardAction(new ValueDelta(1), keyStroke3, 0);
        this.registerKeyboardAction(new ValueDelta(-1), keyStroke4, 0);
        this.registerKeyboardAction(new ValueDelta(1), keyStroke, 0);
        this.registerKeyboardAction(new ValueDelta(-1), keyStroke2, 0);
    }

    public void setText(String string) {
        NumericDocument numericDocument = (NumericDocument)this.getDocument();
        int n = numericDocument.currentVal;
        try {
            numericDocument.currentVal = numericDocument.parse(string);
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (n != numericDocument.currentVal) {
            numericDocument.checkingEnabled = false;
            super.setText(string);
            numericDocument.checkingEnabled = true;
        }
    }

    class ValueDelta
    implements ActionListener {
        int delta;

        public ValueDelta(int n) {
            this.delta = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NumericDocument numericDocument = (NumericDocument)JIntegerTextField.this.getDocument();
            int n = numericDocument.min;
            int n2 = numericDocument.max;
            int n3 = JIntegerTextField.this.getIntegerValue();
            if ((n3 += this.delta) < n) {
                n3 = n2;
            } else if (n3 > n2) {
                n3 = n;
            }
            JIntegerTextField.this.setText(String.valueOf(n3));
        }
    }
}

