/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableColumn
implements Serializable {
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    private int preferredWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport;

    public TableColumn() {
        this(0);
    }

    public TableColumn(int n) {
        this(n, 75, null, null);
    }

    public TableColumn(int n, int n2) {
        this(n, n2, null, null);
    }

    public TableColumn(int n, int n2, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        this.modelIndex = n;
        this.width = n2;
        this.preferredWidth = n2;
        this.cellRenderer = tableCellRenderer;
        this.cellEditor = tableCellEditor;
        this.minWidth = 15;
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.resizedPostingDisableCount = 0;
        this.setHeaderRenderer(this.createDefaultHeaderRenderer());
        this.headerValue = null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setText(object == null ? "" : object.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(0);
        return defaultTableCellRenderer;
    }

    public void disableResizedPosting() {
        ++this.resizedPostingDisableCount;
    }

    public void enableResizedPosting() {
        --this.resizedPostingDisableCount;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public Object getIdentifier() {
        return this.identifier != null ? this.identifier : this.getHeaderValue();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public int getWidth() {
        return this.width;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        this.cellEditor = tableCellEditor;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.cellRenderer;
        this.cellRenderer = tableCellRenderer;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(CELL_RENDERER_PROPERTY, tableCellRenderer2, this.cellRenderer);
        }
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.headerRenderer;
        if (tableCellRenderer == null) {
            throw new IllegalArgumentException("Object is null");
        }
        this.headerRenderer = tableCellRenderer;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(HEADER_RENDERER_PROPERTY, tableCellRenderer2, this.headerRenderer);
        }
    }

    public void setHeaderValue(Object object) {
        Object object2 = this.headerValue;
        this.headerValue = object;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(HEADER_VALUE_PROPERTY, object2, this.headerValue);
        }
    }

    public void setIdentifier(Object object) {
        this.identifier = object;
    }

    public void setMaxWidth(int n) {
        this.maxWidth = Math.max(this.minWidth, n);
        if (this.width > n) {
            this.setWidth(n);
        }
    }

    public void setMinWidth(int n) {
        this.minWidth = Math.max(n, 0);
        if (this.width < n) {
            this.setWidth(n);
        }
    }

    public void setModelIndex(int n) {
        this.modelIndex = n;
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = Math.min(Math.max(n, this.minWidth), this.maxWidth);
    }

    public void setResizable(boolean bl) {
        this.isResizable = bl;
    }

    public void setWidth(int n) {
        int n2 = this.width;
        this.width = Math.min(Math.max(n, this.minWidth), this.maxWidth);
        if (this.changeSupport != null && this.width != n2) {
            this.changeSupport.firePropertyChange(COLUMN_WIDTH_PROPERTY, new Integer(n2), new Integer(this.width));
        }
    }

    public void sizeWidthToFit() {
        Component component = this.getHeaderRenderer().getTableCellRendererComponent(null, this.getHeaderValue(), false, false, 0, 0);
        int n = component.getPreferredSize().width;
        if (n > this.getMaxWidth()) {
            this.setMaxWidth(n);
        }
        if (n < this.getMinWidth()) {
            this.setMinWidth(n);
        }
        this.setWidth(n);
    }
}

