/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.FontMetrics;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    AttributeSet attr;

    public InlineView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.preferenceChanged(null, true, true);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    float getLongestWordSpan() {
        float f = 0.0f;
        try {
            Object object;
            Document document = this.getDocument();
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            String string = document.getText(n, n2 - n);
            int n3 = n;
            int n4 = n;
            if (string != null && string.length() > 0) {
                object = BreakIterator.getWordInstance();
                ((BreakIterator)object).setText(string);
                int n5 = ((BreakIterator)object).first();
                int n6 = ((BreakIterator)object).next();
                while (n6 != -1) {
                    if (n6 - n5 > n4 - n3) {
                        n3 = n5;
                        n4 = n6;
                    }
                    n5 = n6;
                    n6 = ((BreakIterator)object).next();
                }
            }
            if (n4 - n3 > 0) {
                object = this.getFontMetrics();
                String string2 = string.substring(n3, n4);
                f = ((FontMetrics)object).stringWidth(string2);
            }
        }
        catch (BadLocationException badLocationException) {}
        return f;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean bl = object != null ? object.toString().indexOf("underline") >= 0 : false;
        this.setUnderline(bl);
        boolean bl2 = object != null ? object.toString().indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(bl2);
        Object object2 = attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        bl2 = object2 != null ? object2.toString().indexOf("sup") >= 0 : false;
        this.setSuperscript(bl2);
        bl2 = object2 != null ? object2.toString().indexOf("sub") >= 0 : false;
        this.setSubscript(bl2);
    }
}

