/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.io.Serializable;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class AbstractUndoableEdit
implements UndoableEdit,
Serializable {
    protected static final String UndoName = "Undo";
    protected static final String RedoName = "Redo";
    boolean hasBeenDone = true;
    boolean alive = true;

    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public boolean canRedo() {
        return this.alive && !this.hasBeenDone;
    }

    public boolean canUndo() {
        return this.alive && this.hasBeenDone;
    }

    public void die() {
        this.alive = false;
    }

    public String getPresentationName() {
        return "";
    }

    public String getRedoPresentationName() {
        String string = this.getPresentationName();
        string = string != "" ? "Redo " + string : RedoName;
        return string;
    }

    public String getUndoPresentationName() {
        String string = this.getPresentationName();
        string = string != "" ? "Undo " + string : UndoName;
        return string;
    }

    public boolean isSignificant() {
        return true;
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.hasBeenDone = true;
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " hasBeenDone: " + this.hasBeenDone + " alive: " + this.alive;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.hasBeenDone = false;
    }
}

