/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.EncryptMode;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.NoninterKeyExClient;
import org.logi.crypto.protocols.NoninterProtocolClient;

public class EncryptStream
extends FilterOutputStream {
    private EncryptMode emode;

    public void execute(NoninterProtocolClient noninterProtocolClient, boolean bl) throws IOException, CryptoProtocolException {
        OutputStream outputStream = bl ? this : this.out;
        byte[] byArray = noninterProtocolClient.message(null);
        if (byArray == null) {
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(0);
        } else {
            int n = byArray.length;
            outputStream.write(n >>> 24);
            outputStream.write(n >>> 16);
            outputStream.write(n >>> 8);
            outputStream.write(n);
            outputStream.write(byArray);
        }
        outputStream.flush();
        if (!noninterProtocolClient.completed()) {
            throw new CryptoProtocolException("The protocol was not completed");
        }
    }

    public void execute(NoninterProtocolClient noninterProtocolClient) throws IOException, CryptoProtocolException {
        this.execute(noninterProtocolClient, true);
    }

    public synchronized void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.emode == null) {
            throw new IOException("This stream has been closed.");
        }
        byte[] byArray2 = this.emode.encrypt(byArray, n, n2);
        if (byArray2.length > 0) {
            this.out.write(byArray2, 0, byArray2.length);
        }
    }

    public synchronized void flush() throws IOException {
        if (this.emode == null) {
            throw new IOException("This stream has been closed.");
        }
        byte[] byArray = this.emode.flush();
        if (byArray.length > 0) {
            this.out.write(byArray, 0, byArray.length);
        }
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.emode != null) {
            this.flush();
            this.emode.close();
            this.emode = null;
            this.out.close();
        }
    }

    public EncryptStream(OutputStream outputStream, NoninterKeyExClient noninterKeyExClient, EncryptMode encryptMode) throws CryptoProtocolException, IOException {
        super(outputStream);
        this.emode = encryptMode;
        if (noninterKeyExClient != null) {
            this.execute(noninterKeyExClient, false);
            try {
                CipherKey cipherKey = (CipherKey)noninterKeyExClient.sessionKey();
                if (cipherKey == null) {
                    throw new CryptoProtocolException("A non-interactive protocol should only need one message.");
                }
                encryptMode.setKey(cipherKey);
            }
            catch (ClassCastException classCastException) {
                throw new CryptoProtocolException("The key-exchange protocol proposes to use a non-cipher key for encryption.");
            }
        }
        if (encryptMode.getKey() == null) {
            throw new CryptoProtocolException("No key specified or exchanged");
        }
    }
}

