
package com.limegroup.gnutella.bootstrap;

import java.text.ParseException;

/**
 * The list of default GWebCache urls, used the first time LimeWire starts, or
 * if the gnutella.net file is accidentally deleted.  Entries in the list will
 * eventually be replaced by URLs discovered during urlfile=1 requests.  Order
 * does not matter.
 *
 * THIS FILE IS AUTOMATICALLY GENERATED FROM MAKE_DEFAULT.PY.
 */
public class DefaultBootstrapServers {
    /**
     * Adds all the default servers to bman. 
     */
    public static void addDefaults(BootstrapServerManager bman) {
        for (int i=0; i<urls.length; i++) {
            try {
                BootstrapServer server=new BootstrapServer(urls[i]);
                bman.addBootstrapServer(server);
            } catch (ParseException ignore) {
            }                
        }
    }

    //These should NOT be URL encoded.
    static String[] urls=new String[] {
        "http://194.109.226.113/gnucleus/gcache.asp",
        "http://209.197.225.202/gcache.php",
        "http://66.78.61.146/",
        "http://aphasia.cc.gatech.edu:8080/gcache.php",
        "http://bbs.robertwoolley.co.uk/GWebCache/gcache.php",
        "http://bbs.robertwoolley.co.uk/gwebcache/gcache.php",
        "http://bobsmith.kicks-ass.org/gwebcache/gcache.php",
        "http://cache.mynapster.com/index.php",
        "http://calamity.panda.clarkey.net:46787/doris.php",
        "http://cgi.rz.tu-ilmenau.de/~mifl-ii/gcache.php",
        "http://cs-people.bu.edu/leith/gnuCache/gcache.php",
        "http://danut.homeip.net/gcache.php",
        "http://debian.inxide.it/gcache/gcache.php",
        "http://etomi.com/gcache/gcache.php",
        "http://firebird.shacknet.nu:8888/cash.php",
        "http://g-web-cache1.paonet.org/gcache/gcache.php",
        "http://g.dumbek.net/gcache.php",
        "http://g2cache.theg2.net/gwcache/lynnx.asp",
        "http://gattinger.org/gcache/gcache.php",
        "http://gcache.woodenpickle.com/gcache.php",
        "http://goodwid.feather.net/gweb/gcache.php",
        "http://gwc.collie.net/gcache.php",
        "http://gwc.fspn.cryptnet.net/gcache.cgi",
        "http://gwc.to-j.com/gwc.php",
        "http://gwebcache.amateur-hour.net/gcache.php",
        "http://gwebcache.bearshare.net/",
        "http://gwebcache.heypete.com/gcache/gcache.php",
        "http://gwebcache.jonatkins.com/cgi-bin/gwebcache.cgi",
        "http://gwebcache.mrhightek.net/gcache.php",
        "http://gwebcache.rootdir.de/gcache.php",
        "http://gwebcache.zerouptime.ch/gcache.php",
        "http://gwebcache2.jonatkins.com/cgi-bin/gwebcache.cgi",
        "http://gwebcache3.jonatkins.org.uk/perlgcache.cgi",
        "http://home.no.net/dforsb/gnet/gcache.php",
        "http://home.zk3d.com/gwebcache/gcache.php",
        "http://intranet.ktg.se/~andbje/gnutella/gcache",
        "http://ixm.goquest.com/gnu/gcache.php",
        "http://jaxx.org/gcache.php",
        "http://junkyjunk.com/gwebcache/gcache.php",
        "http://kioan.users.uth.gr/GnucleusWebCache/gcache.php",
        "http://kolecke.net/gwebcache/gcache.php",
        "http://members.lycos.co.uk/coolebra/gwebcache-0.7.4/gcache.php",
        "http://members.lycos.co.uk/digitaldimensions/gwebcache/gcache.php",
        "http://members.lycos.co.uk/espinhoso/Gcache/gcache.php",
        "http://members.lycos.co.uk/gressen/gcache/gcache.php",
        "http://members.lycos.co.uk/jokattack/cache/index.php",
        "http://members.lycos.co.uk/petera2003/cache_thingy/gcache.php",
        "http://members.lycos.co.uk/wheelzoff/gwebcache/gcache.php",
        "http://members.lycos.nl/jocat3/gcache.php",
        "http://members.lycos.nl/killerarnold/gcache.php",
        "http://members.lycos.nl/silvermaster59/gcache.php",
        "http://members.tripod.co.uk/jokattack/cache",
        "http://members.tripod.co.uk/jokattack/cache/index.php",
        "http://membres.lycos.fr/tium2000/gcache.php",
        "http://membres.lycos.fr/waryde/gnuc/gcache.php",
        "http://moby.sis.it/~marchino/gcache.php",
        "http://move.along.move.along.there.is.nothing.to.see.here.at.bishopston.net:23558/",
        "http://napshare.sourceforge.net/cache/gcache.php",
        "http://olympus.het.brown.edu/gwebcache-0.7.5/gcache.php",
        "http://r3dk0w.dyndns.org/gwebcache/gcache.php",
        "http://raphael.manfredi.free.fr/gwc/gcache.php",
        "http://read.the.disastrous.info/gwebcache/gcache.php",
        "http://s91.tku.edu.tw/~291510500/gwebcache/gcache.php",
        "http://se.vatavia.net/gcache.php",
        "http://server.lohheide.ath.cx/jpwebs/webspace/Spooky/gcache.php",
        "http://server925.gisol.com/~enhance/search/files/cache/gcache.php",
        "http://theccu.org/webservices/GnuCache/index.php",
        "http://theccu.org/webservices/gnucache/index.php",
        "http://unknown.pingtime.com/gwebcache/gcache.php",
        "http://usuarios.lycos.es/coolebra/gwebcache/gcache.php",
        "http://www.apexo.de/gnucache/gcache.php",
        "http://www.arach.net.au/~holmesd6/gcache.php",
        "http://www.asiinfo.net/gwebcache/gcache.php",
        "http://www.bdarules.com/gcache.php",
        "http://www.bstsystems.com/gwebcache/gcache.php",
        "http://www.celeborn.dnsalias.org/gwebcache/gcache.php",
        "http://www.cgs-services.de/gwebcache/gcache.php",
        "http://www.easypublish.net/gwebcache/gcache.asp",
        "http://www.emixode.com/gcache/hipe.dll",
        "http://www.etomi.com/gcache/gcache.php",
        "http://www.guox.de/lynnx.aspx",
        "http://www.hottdeals.com/postNuke7/gWebCache",
        "http://www.hottdeals.com/postNuke7/gWebCache/gcache.php",
        "http://www.inthetrunk.com/gcache/gcache.php",
        "http://www.jetzweb.de/metacyborg/gc/gcache.php",
        "http://www.julianfamily.org/gcache.php",
        "http://www.justthefaqs.org/gnu/gcache.php",
        "http://www.labyrinth.net.au/~micallef/gcache/gcache.php",
        "http://www.markus-wolf-home.de/GNetCache/index.php",
        "http://www.markus-wolf-home.de/GWebCache/gcache.php",
        "http://www.melissazone.com/gwebcache/gcache.php",
        "http://www.newrisedesigns.com/gcache/gcache.php",
        "http://www.ontheside.net/gcache/gcache.php",
        "http://www.perser.org/gcache/gcache.php",
        "http://www.pik.org/GWebCache/gcache.php",
        "http://www.progoth.com/gwc/gcache.php",
        "http://www.puxie.nl/gwebcache/gcache.php",
        "http://www.roundbox.ws/gwebcache/gcache.php",
        "http://www.ryannet.net/gwebcache/gcache.php",
        "http://www.sonic.net/~oceanowl/gcache.php",
        "http://www.theinfants.com/gweb/gcache.php",
        "http://www.tigersden.co.uk/gwebcache/gcache.php",
        "http://www.torg.org/gwebcache/gcache.php",
        "http://www.universalopps.com/gcache/gcache.php",
        "http://www.versus167.de/gwebcache/gcache.php",
        "http://www.videoblaster.it/gcache.php",
        "http://www.waddell.ch/cache",
        "http://www.waddell.ch/cache/",
        "http://www.warwick.ac.uk/~csvbn/gcache/gcache.php",
        "http://www.williams-clan.net/gcache/gcache.php",
        "http://www.wtndrifters.com/gcache.php",
        "http://www.xmission.com/~mcintyre/gcache/gcache.php",
        "http://www.xolox.nl/gwebcache",
        "http://www.xolox.nl/gwebcache/default.asp",
        "http://www.xolox.nl/gwebcache/xolox/lynn.asp",
        "http://www.zadox.com/gwebcache",
        "http://zilched.com/gnucleus/gcache.php"
    };
}
