package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.util.CommonUtils;

/**
 * This class manages the "view" menu that allows the user to dynamically select
 * which tabs should be viewable at runtime & themes to use.
 */
final class ViewMenu extends AbstractMenu {
    
    ViewMenu(final String key) {
        super(key);
        if(!CommonUtils.isMacClassic()) {
            MENU.add( new ShowHideMenu("VIEW_SHOW_HIDE").getMenu() );
            addSeparator();
        }
        MENU.add( new ThemeMenu("VIEW_THEMES").getMenu() );
    }
}







