package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.ButtonRow;
import java.awt.event.*;
import java.awt.Component;
import java.io.*;

/**
 * This class contains the <tt>ButtonRow</tt> instance for the options 
 * window.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class OptionsButtonPanel {

	/**
	 * Handle to the enclosed <tt>ButtonRow</tt> instance.
	 */
	private ButtonRow _buttonRow;

	/**
	 * The constructor creates the <tt>ButtonRow</tt>.
	 */
	OptionsButtonPanel() {
        String[] buttonLabelKeys = {
			"GENERAL_OK_BUTTON_LABEL",
			"GENERAL_CANCEL_BUTTON_LABEL",
			"GENERAL_APPLY_BUTTON_LABEL"
		};

        String[] toolTipKeys = {
			"GENERAL_OK_BUTTON_TIP",
			"GENERAL_CANCEL_BUTTON_TIP",
			"GENERAL_APPLY_BUTTON_TIP",
		};
        ActionListener[] listeners = {
			new OKListener(), new CancelListener(), new ApplyListener()
		};
		_buttonRow= new ButtonRow(buttonLabelKeys,toolTipKeys,listeners,
								  ButtonRow.X_AXIS,ButtonRow.LEFT_GLUE);
			
	}

	/**
	 * Returns the <tt>Component</tt> that contains the <tt>ButtonRow</tt>.
	 */
	Component getComponent() {
		return _buttonRow;
	}

    /** 
	 * The listener for the ok button.  Applies the current options and 
	 * makes the window not visible.
	 */
    private class OKListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
			// close the window only if the new settings 
			// work correctly, as the user may need to
			// change the settings before closing.
			try {
				OptionsMediator.instance().applyOptions();
				OptionsMediator.instance().setOptionsVisible(false);
			} catch(IOException ioe) {
				// nothing we should do here.  a message should
				// have been displayed to the user with more information
			}
        }
    }

    /** 
	 * The listener for the cancel button.
	 */
    private class CancelListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
			OptionsMediator.instance().setOptionsVisible(false);
        }
    }

    /** 
	 * The listener for the apply button.  Applies the current settings.
	 */
    private class ApplyListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
			try {
				OptionsMediator.instance().applyOptions();
			} catch(IOException ioe) {
				// nothing we should do here.  a message should
				// have been displayed to the user with more information
			}
        }
    }
}
