
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIMediator;

import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import com.limegroup.gnutella.settings.QuestionsHandler;

import com.limegroup.gnutella.gui.GUIMediator;

/**
 * Simple popup menu that shows the current columns,
 * and allows the user to display/hide them
 * @author Sam Berlin
 *  idea from the getColumnSelectionMenu in /search/TableColumnFilter
 */
public class ColumnSelectionMenu {

    /**
     * The string used to signify the columnId property
     */
    protected static final String COLUMN_ID = "columnId";

    /**
     * Revert to default string
     */
    private static final String REVERT_DEFAULT =
        GUIMediator.getStringResource("GENERAL_REVERT_TO_DEFAULT");

    /**
     * The actual popup menu.
     */
    protected final JPopupMenu _menu = new JPopupMenu();

    /**
     * The LimeJTable this menu is associated with
     */
    private final LimeJTable _table;

    /**
     * Constructs the popupmenu & actionlistener associated with the
     * table & model.
     */
    public ColumnSelectionMenu(LimeJTable table) {
        _table = table;
        DataLineModel model = (DataLineModel)_table.getModel();

        // add the 'revert to default' option.
        ActionListener reverter = new ReverterListener();
        JMenuItem revert = new JMenuItem(REVERT_DEFAULT);
        ColumnPreferenceHandler cph = _table.getColumnPreferenceHandler();
        //if there is no preferences handler or the values are already default,
        //disable the option
        if( cph == null || cph.isDefault() )
            revert.setEnabled(false);
        else
            revert.addActionListener(reverter);
        _menu.add(revert);
        
        _menu.addSeparator();

        // add the individual hide/display options
        ActionListener listener = new SelectionActionListener();
        Object id;
        String name;
        JCheckBoxMenuItem item;
        for( int i = 0; i < model.getColumnCount(); i++) {
            name = model.getColumnName(i);
            id = model.getColumnId(i);
            item = new JCheckBoxMenuItem( name, table.isColumnVisible(id) );
            item.putClientProperty( COLUMN_ID, id );
            item.addActionListener( listener );
            _menu.add( item );
        }
    }

    /**
     * Returns the popup menu
     */
    public JPopupMenu getComponent() { return _menu; }


    /**
     * Simple ActionListener class that will display/hide a column
     * based on the columnId property of the source.
     */
    protected class SelectionActionListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
             JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
             try {
                _table.setColumnVisible( item.getClientProperty(COLUMN_ID), item.getState() );
                _table.getTableHeader().setDraggedColumn(null);
             } catch (LastColumnException ee) {
                GUIMediator.showError("ERROR_REMOVE_LAST_COL",
                    QuestionsHandler.REMOVE_LAST_COLUMN);
             }
        }
    }

    /**
     * Simple class that calls 'revertToDefault' on the ColumnPreferenceHandler
     * of the LimeJTable
     */
    protected class ReverterListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            _table.getColumnPreferenceHandler().revertToDefault();
        }
    }
}