package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.util.CommonUtils; 
import com.limegroup.gnutella.gui.*;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.ComponentMediator; 
import javax.swing.*;
import java.awt.*;

/**
 * This class constructs the search/download tab, including all UI elements.
 */
public final class SearchDownloadTab extends AbstractTab {
	
	/**
	 * Split pane for the split between the search input panel and the 
	 * search results panel.
	 */
	private final JSplitPane SPLIT_PANE;
	
	/**
	 * Split pane for the split between the search and download sections
	 * of the window.
	 */
	private final JSplitPane SEARCH_DOWNLOAD_SPLIT_PANE;

	/**
	 * Constructs the tab for searches and downloads.
	 *
	 * @param SEARCH_MEDIATOR the <tt>SearchMediator</tt> instance for 
	 *  obtaining the necessary ui components to add
	 * @param DOWNLOAD_MEDIATOR the <tt>DownloadMediator</tt> instance for 
	 *  obtaining the necessary ui components to add
	 */
	public SearchDownloadTab(final SearchMediator SEARCH_MEDIATOR, 
							 final ComponentMediator DOWNLOAD_MEDIATOR) {
		super("SEARCH", GUIMediator.SEARCH_INDEX);
        SEARCH_DOWNLOAD_SPLIT_PANE = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
													SEARCH_MEDIATOR.getComponent(),
													DOWNLOAD_MEDIATOR.getComponent());
        SEARCH_DOWNLOAD_SPLIT_PANE.setOneTouchExpandable(true);
		SEARCH_DOWNLOAD_SPLIT_PANE.setPreferredSize(new Dimension(200,200));
		SEARCH_DOWNLOAD_SPLIT_PANE.setDividerLocation(1000);

		JComponent searchBoxPanel = SEARCH_MEDIATOR.getSearchBoxPanel();
		searchBoxPanel.setPreferredSize(new Dimension(100,100));
        
        SPLIT_PANE = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
									searchBoxPanel,
									SEARCH_DOWNLOAD_SPLIT_PANE);
        SPLIT_PANE.setOneTouchExpandable(true);
		
		// the Mac handles the location differently, so special case it
        if (CommonUtils.isMacClassic())
            SPLIT_PANE.setDividerLocation(190);
	}

	/**
	 * Sets the location of the search/download divider.
	 *
	 * @param loc the location to set the divider to
	 */
	public void setDividerLocation(int loc) {
		SEARCH_DOWNLOAD_SPLIT_PANE.setDividerLocation(loc);
	}

	/**
	 * Sets the location of the search/download divider.
	 *
	 * @param loc the location to set the divider to
	 */
	public void setDividerLocation(double loc) {
		SEARCH_DOWNLOAD_SPLIT_PANE.setDividerLocation(loc);
	}

	public void storeState(boolean state) {
		// the search tab can never be invisible, so this isn't necessary
	}

	public JComponent getComponent() {
		return SPLIT_PANE;
	}
}
