package com.limegroup.gnutella.update;

/**
 * This class maintains protected constants and variables for 
 * <tt>ServletLocalUpdateInfo</tt> and <tt>ClientLocalUpdateInfo</tt>,
 * the classes that contain the data for the client machine 
 * requesting the update.  This class simply ensures that they are
 * using the same values.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
public abstract class AbstractLocalUpdateInfo {	
    
	/** 
	 * Constant <tt>String</tt> for the os key.
	 */
	protected final String OLD_OS = "OS";

	/** 
	 * Constant <tt>String</tt> for the pre-LimeWire 1.8 LimWire version key.
	 */
	protected final String OLD_LIMEWIRE_VERSION = "LIMEWIRE_VERSION";
    
	/** 
	 * Constant <tt>String</tt> for the pre-LimeWire 1.8 JVM version key.
	 */
	protected final String OLD_JVM = "JVM";
    
	/** 
	 * Constant <tt>String</tt> for the os key.
	 */
	protected final String OS = "1";

	/** 
	 * Constant <tt>String</tt> for the LimWire version key.
	 */
	protected final String LIMEWIRE_VERSION = "2";

	/** 
	 * Constant <tt>String</tt> for the JVM version key.
	 */
	protected final String JVM = "3";
    
    /**
     * Constant <tt>String</tt> for the guid key.
     */
    protected final String GUID = "4";
    
    /**
     * Constant <tt>String</tt> for the accepting incoming connections key.
     */
    protected final String ACCEPTED_INCOMING = "5";
    
    /**
     * Constant <tt>String</tt> for the private ip key.
     */
    protected final String PRIVATE_IP = "6";
    
    /**
     * Constant <tt>String</tt> for the key for ever having met all of the
     * requirements for a supernode.
     */
    protected final String EVER_SUPERNODE = "7";
    
    /**
     * Constant <tt>String</tt> for the maximum recorded upstream bytes
     * passed.
     */
    protected final String MAX_UPSTREAM = "8";
    
    /**
     * Constant <tt>String</tt> for the maximum recorded downstream bytes
     * passed.
     */
    protected final String MAX_DOWNSTREAM = "9";
    
    /**
     * Constant <tt>String</tt> for the average uptime key.
     */
    protected final String AVERAGE_UPTIME = "10";

    /**
     * Constant <tt>String</tt> for the ads version key.
     */
	protected final String AD_VERSION = "11";

	/** 
	 * String for the operating system.
	 */
	protected String _os;

	/** 
	 * String for the version of the application.
	 */
	protected String _limeWireVersion;

	/** 
	 * String for the jvm.
	 */
	protected String _jvm;
    
    /**
     * String for the GUID for maintaining data on the servlet.
     */
    protected String _guid;
    
    /**
     * Variable for whether or not the client requesting the update has
     * ever accepted an incoming connection.
     */
    protected String _everAcceptedIncoming;
    
    /**
     * Variable for whether or not the client requesting the update has
     * a private ip address.
     */
    protected String _isPrivateIP;
      
    /**
     * Variable for whether or not the client requesting the update has
     * ever qualified as meeting the requirements of a supernode.
     */
    protected String _everSupernodeCapable;
    
    /**
     * Variable for the average uptime of the client requesting the update.
     */
    protected String _averageUptime;
    
    /**
     * Variable for the maximum recorded downstream bytes per second ever
     * passed by this node.
     */
    protected String _maxDownstreamBytesPerSec;
    
    /**
     * Variable for the maximum recorded upstream bytes per second ever
     * passed by this node.
     */
    protected String _maxUpstreamBytesPerSec;

	/**
	 * Variable for the version of ads that the client is running.
	 */
	protected String _adVersion;

	/** 
	 * Constructor for creating a local update info object with none of 
	 * the fields initially set.  To create a useful 
	 * <tt>LocalUpdateInfo</tt> object, all of the fields must be set.
	 */
	protected AbstractLocalUpdateInfo() {}
        
	/**
	 * Returns the data contained in this object as a string.  This is used
     * primarily in generating the servlet log.
     *
     * @return a <tt>String</tt> containing the data held in this object
	 */
    public String toString() {
        return  "OS="+_os+
                "\nLW_VERSION="+_limeWireVersion+
                "\nJVM="+_jvm+
                "\nGUID="+_guid+
                "\nACC_INCOMING="+_everAcceptedIncoming+
                "\nPRIVATE_IP="+_isPrivateIP+
                "\nEVER_SUPERNODE="+_everSupernodeCapable+
                "\nMAX_UPSTREAM="+_maxUpstreamBytesPerSec+
                "\nMAX_DOWNSTREAM="+_maxDownstreamBytesPerSec+
                "\nAVERAGE_UPTIME="+_averageUptime+
		        "\nAD_VERSION="+_adVersion+
                "\n";
    }
}






