package com.limegroup.gnutella.update;

/**
 * This class supplies the update information from the servlet.  It contains
 * the update action to take.  In contrast to <tt>LocalUpdateInfo</tt>, which
 * is originally created on the client side and is reconstructed by the
 * servlet based on the supplied url-encoded string, <tt>RemoteUpdateInfo</tt>
 * is first constructed on the servlet side and is reconstructed on the 
 * client to extract the data necessary to perform the update.<p>
 *
 * When the <tt>RemoteUpdateInfo</tt> object is constructed on the client side,
 * however, it does not simply replicate the object created in the servlet.
 * Rather, it sets the appropriate update settings in the <tt>Updator</tt>
 * object for the type of update being performed.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
public abstract class AbstractRemoteUpdateInfo {
	    
    /** 
	 * Key identifying the directive to use for the update.
	 */
    protected final String DIRECTIVE = "DIRECTIVE";
	
    /** 
	 * Key name for the "message to display" value.
	 */
    protected final String MESSAGE_TO_DISPLAY = "MESSAGE_TO_DISPLAY";
	
    /**
	 * Key name for the url to load for either opening a web page
	 * or downloading a jar.
	 */
    protected final String UPDATE_URL = "UPDATE_URL";
	
    /**
	 * Constant for the classpath key.  the classpath is the classpath
	 * that LimeWire will use to load the necessary files on startup.
	 */
    protected final String UPDATE_CLASSPATH = "UPDATE_CLASSPATH";
	
    /**
     * Constant for the main class key.  the main class is used to launch
     * the application on startup.
     */
    protected final String UPDATE_MAIN_CLASS = "UPDATE_MAIN_CLASS";

    /** 
     * Directive to ignore the update.
     */
    protected final String NO_UPDATE_STRING = "NO_UPDATE";

    /**
     * Directive for updating one or more jar files.
     */
    protected final String UPDATE_JAR_STRING = "UPDATE_JAR";

    /** 
     * Directive for updating the ads.
     */
    protected final String UPDATE_ADS_STRING = "UPDATE_ADS_STRING";
	
    /** 
     * Directive for loading a web page.
     */
    protected final String OPEN_WEB_PAGE_STRING = "OPEN_WEB_PAGE";

    /** 
     * Directive for displaying a message to the user.
     */
    protected final String DISPLAY_MESSAGE_STRING = "DISPLAY_MESSAGE";
   
    /**
     * Constructor taking no arguments for use in constructing the
     * <tt>AbstractRemoteUpdateInfo</tt> -- reserved for subclasses.
     */
    protected AbstractRemoteUpdateInfo() {}
}
