package com.limegroup.gnutella.update;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.settings.*;
import java.net.URLEncoder;

/**
 * This class encapsulates all of the data for an individual client machine
 * for an individual update post.<p>  
 *
 * This class collects all of the data for the local machine and provides
 * access to that data in url-encoded form.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class ClientLocalUpdateInfo extends AbstractLocalUpdateInfo {	    
	
	/**
	 * Constructor for creating a local update info object with none of 
	 * the fields initially set.  To create a useful 
	 * <tt>LocalUpdateInfo</tt> object, all of the fields must be set.
	 */
	ClientLocalUpdateInfo() {
		_os = CommonUtils.getOS();
		_limeWireVersion = CommonUtils.getLimeWireVersion();
		_jvm = CommonUtils.getJavaVersion();	
        _guid = ApplicationSettings.CLIENT_ID.getValue();
        
        // specialized values for determining the potential of supernodes
        // on the network
        _everAcceptedIncoming = 
			String.valueOf(ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue());
        _everSupernodeCapable = 			
            String.valueOf(UltrapeerSettings.EVER_ULTRAPEER_CAPABLE.getValue());
        _isPrivateIP = 
			String.valueOf(ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue());
        _averageUptime = 
            String.valueOf(ApplicationSettings.AVERAGE_UPTIME.getValue());
        _maxDownstreamBytesPerSec = 
            String.valueOf(DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue());
        _maxUpstreamBytesPerSec =
            String.valueOf(UploadSettings.MAX_UPLOAD_BYTES_PER_SEC.getValue());
	}

	/** 
	 * Returns a string in URL encoded format that contains all of the 
     * information for this operating system, version of the application, 
     * and jvm.
     *
     * @return a url-encoded <tt>String</tt> containing all of the 
     *         information about the local machine to post to the servlet
	 */
	final String getPostRequestString() {
		StringBuffer sb = new StringBuffer();
		sb.append(OS);
        sb.append("=");
		sb.append(URLEncoder.encode(_os));
        sb.append("&");
		sb.append(LIMEWIRE_VERSION);
        sb.append("=");
		sb.append(URLEncoder.encode(_limeWireVersion));
        sb.append("&");
		sb.append(JVM);
        sb.append("=");
		sb.append(URLEncoder.encode(_jvm));
        sb.append("&");
        sb.append(GUID);
        sb.append("=");
		sb.append(URLEncoder.encode(_guid));
        sb.append("&");
        sb.append(ACCEPTED_INCOMING);
        sb.append("=");
		sb.append(URLEncoder.encode(_everAcceptedIncoming));
        sb.append("&");
        sb.append(PRIVATE_IP);
        sb.append("=");
		sb.append(URLEncoder.encode(_isPrivateIP));
        sb.append("&");
        sb.append(EVER_SUPERNODE);
        sb.append("=");
		sb.append(URLEncoder.encode(_everSupernodeCapable));
        sb.append("&");
        sb.append(MAX_UPSTREAM);
        sb.append("=");
		sb.append(URLEncoder.encode(_maxUpstreamBytesPerSec));
        sb.append("&");
        sb.append(MAX_DOWNSTREAM);
        sb.append("=");
		sb.append(URLEncoder.encode(_maxDownstreamBytesPerSec));
        sb.append("&");
        sb.append(AVERAGE_UPTIME);
        sb.append("=");
		sb.append(URLEncoder.encode(_averageUptime));
		return sb.toString();
	}
}
