package com.limegroup.gnutella.update;


/**
 * This class encapsulates all of the data for an individual client machine
 * for an individual update post.<p>  
 *
 * The servlet utilizes this class to reconstruct the data for the
 * client machine to determine the update information to return.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
public class ServletLocalUpdateInfo extends AbstractLocalUpdateInfo {	
    
    /**
     * Adds one key/value pair to the data stored in this object.  This
     * method is used on the servlet to reconstruct the 
     * <tt>LocalUpdateInfo</tt> object.
     *
     * @param key the key for the pair
     * @param value the value for the pair
     */
    public void addKeyValuePair(final String key, final String value) {
        
        // these are the old pre-LimeWire 1.8 keys that were longer than
        // necessary, just using up a tiny bit more bandwidth and CPU
        if(key.equals(OLD_OS))
            _os = value;
        else if(key.equals(OLD_LIMEWIRE_VERSION))
            _limeWireVersion = value;
        else if(key.equals(OLD_JVM))
            _jvm = value;
        
        // these are the new, shorter keys with some new keys added in
        // LimeWire 1.8 for getting some better picture of the network
        else if(key.equals(OS))
            _os = value;
        else if(key.equals(LIMEWIRE_VERSION))
            _limeWireVersion = value;
        else if(key.equals(JVM))
            _jvm = value;
		else if(key.equals(AD_VERSION))
			_adVersion = value;
        else if(key.equals(GUID))
            _guid = value;
        else if(key.equals(ACCEPTED_INCOMING))
            _everAcceptedIncoming = value;
        else if(key.equals(MAX_UPSTREAM))
            _maxUpstreamBytesPerSec = value;
        else if(key.equals(MAX_DOWNSTREAM))
            _maxDownstreamBytesPerSec = value;
        else if(key.equals(EVER_SUPERNODE))
            _everSupernodeCapable = value;
        else if(key.equals(AVERAGE_UPTIME))
            _averageUptime = value;
        else if(key.equals(PRIVATE_IP))
            _isPrivateIP = value;
        else {
			// just ignore it
        }
    }
    
	/**
	 * Accessor for the operating system variable.
     *
     * @return a <tt>String</tt> representing the operating system
	 */
	public String getOS() {
		return _os;
	}

	/**
	 * Accessor for the application version variable.
     * 
     * @return a <tt>String</tt> representing the version of the 
     *         application
	 */
	public String getLimeWireVersion() {
		return _limeWireVersion;
	}

	/**
	 * Returns the ads version for the client requesting the update.
	 *
	 * @return the string for the ad version on the client
	 */
    public String getAdVersion() {
		return _adVersion;
	}

    /**
     * Returns the java version for the client requesting the update.
     *
     * @return the java version for the client
     */
    public String getJavaVersion() {
        return _jvm;
    }
}









