/****************************************************************************
**
** $Id: CCvsOutput.cpp,v 1.7 2004/01/11 20:08:13 riemer Exp $
**
** Copyright (C) 1999-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

#include "CCvsOutput.h"
#include "globals.h"

#include "SyntaxHighlighter.h"
#include "SyntaxHighlighter-compat-3.0.x.h"


CCvsOutput::CCvsOutput(QPopupMenu ** menu, QWidget * parent, const char * name)
  : QTextEdit(parent,name),
    m_ppMenu(menu),
    m_currentMode(OFF) {

  QTextEdit::setUndoDepth(0);
  m_pSyntaxHighlighter = new CSyntaxHighlighter(this);
}

CCvsOutput::~CCvsOutput() {

}

void CCvsOutput::reset() {
  QTextEdit::setText("");
  QTextEdit::setCursorPosition(0, 0);
  m_modeList.clear();
  m_toggleText = "";
}

void CCvsOutput::insert( const QString & text, uint insertionFlags) {

  QString insTxt = text;

  int pos = 0;
  int startPos = 0;
  int endPos = 0;

  switch (m_currentMode) {

    case OFF: {
      break;
    }
    case QUIET: {
      if (m_eolMissing) {
	pos = insTxt.find("\n");
	if (pos > -1) {
	  insTxt = insTxt.mid(pos+1);
	  m_eolMissing = FALSE;
	}
	pos = 0;
      }
      while ((startPos = insTxt.find("cvs server: ",pos)) > -1) {
	if ( (endPos = insTxt.find("\n",startPos)) > -1) {
	  insTxt.remove(startPos,endPos-startPos+1);
	  pos = startPos;
	} else {//no \n ==> last line
	  insTxt.truncate(startPos);
	  m_eolMissing = TRUE;
	  break;
	}
      }
      pos = 0;
      while ((startPos = insTxt.find("? ",pos)) == pos) {
	if ( (endPos = insTxt.find("\n",startPos)) > -1) {
	  insTxt.remove(startPos,endPos-startPos+1);
	  pos = startPos;
	} else {//no \n ==> last line
	  insTxt.truncate(startPos);
	  m_eolMissing = TRUE;
	  break;
	}
      }
      break;
    }
    default: {
      qDebug("CCvsOutput::Mode unknown: "+QString::number(m_currentMode));
    }
  }
  m_toggleText += text;
  QTextEdit::insert(insTxt,insertionFlags);
}

void CCvsOutput::setMode( const int icmd) {

  if (CvsOptions::g_bQuietCvs) m_currentMode = QUIET;
  else m_currentMode = OFF;

  outputMode om;
  om.icmd = icmd;
  om.mode = m_currentMode;
  om.pos = QTextEdit::length();
  om.togglePos = m_toggleText.length();

  m_eolMissing = FALSE;
  m_modeList.append(om);
  setHighlightMode(icmd);
}

void CCvsOutput::setHighlightMode(const int icmd) {
  SyntaxHighlighter::HighlightMode highlightMode;
  switch(icmd) {
    case STATUS_CMD: 
    case STATUS_FILES_CMD:
      highlightMode = SyntaxHighlighter::HM_STATUS;
      break;
    case UPDATE_DIR_CMD:
    case UPDATE_FILES_CMD:
    case CHECKOUT_CMD:
    case QUERY_UPDATE_CMD:
    case QUERY_UPDATE_ALL_CMD:
    case MERGE_REV_INTO_CMD:
    case MERGEDIR_CMD:
    case MERGEFILES_CMD:
    case AUTOUPDATE_DIR_CMD:
    case AUTOUPDATE_DIR_NO_PRUNE_CMD:
    case CHECKOUT_NO_PRUNE_CMD:
    case MERGEDIR_NO_PRUNE_CMD:
    case UPDATE_VIRTUAL_DIR_CMD:
    case IMPORT_CMD:
      highlightMode = SyntaxHighlighter::HM_UPDATE;
      break;
    case DIFF_CMD:
      highlightMode = SyntaxHighlighter::HM_DIFFSBS;
      break;
    case LOGINANDOUT_CMD:
      highlightMode = SyntaxHighlighter::HM_LOGIN;
      break;
    case NOT_INTERACTIVE_CMD:
      highlightMode = SyntaxHighlighter::HM_DIFF;
      break;
    default: {
      highlightMode = SyntaxHighlighter::HM_NONE;
      break;
    }
  }
  m_pSyntaxHighlighter->setMode(highlightMode);
}

QPopupMenu * CCvsOutput::createPopupMenu ( const QPoint &) {
  emit fillOutputMenu(m_currentMode);
  return *m_ppMenu;
}

void CCvsOutput::toggleShowAll() {
  QString tmp = QTextEdit::text();
  QTextEdit::setText("");
  ModeList::iterator it;
  int startPos = 0;
  for (it = m_modeList.begin(); it != m_modeList.end(); ) {
    setHighlightMode( (*it).icmd);
    ++it;
    if (it == m_modeList.end()) {
      QTextEdit::insert(m_toggleText.mid(startPos));
    } else {
      int tmpPos = (*it).pos;
      (*it).pos = (*it).togglePos;
      (*it).togglePos = tmpPos;
      QTextEdit::insert(m_toggleText.mid(startPos,(*it).pos-startPos));
      startPos = (*it).pos;
    }
  }
  m_toggleText = tmp;
}
