/****************************************************************************
**
** $Id: cvsconfig.cpp,v 1.72 2004/05/03 11:41:50 hemer Exp $
**
** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
**                         Frank Hemer <frank@hemer.at> and
**                         Jose Hernandez <joseh@tesco.net> and
**                         Joerg Preiss <auba@auba.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#include "config.h"

//----------------------------------------------------------------------------

#include <qregexp.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "cvsconfig.h"

//----------------------------------------------------------------------------

const char CvsConfig::Version[]                 = "/lincvs/Version";
const char CvsConfig::Debug[]                   = "/lincvs/Debug";
const char CvsConfig::LogLevel[]                = "/lincvs/LogLevel";
const char CvsConfig::CheckStatusIntervall[]	= "/lincvs/Timer/checkStatusIntervall";
const char CvsConfig::CheckStatusLevel[]        = "/lincvs/Timer/checkStatusLevel";
const char CvsConfig::ProgressIntervall[]	= "/lincvs/Timer/progressIntervall";

const char CvsConfig::AutoUpdate[]              = "/lincvs/AutoUpdate/Enabled";
const char CvsConfig::AutoUpdateIntervall[]     = "/lincvs/AutoUpdate/Intervall";

const char CvsConfig::cvsPassFile[]             = "/lincvs/CvsPassFilePath";
const char CvsConfig::cvsPath[]                 = "/lincvs/CvsPath";
const char CvsConfig::cvsVersion[]              = "/lincvs/CvsVersion";
const char CvsConfig::useDirWatch[]             = "/lincvs/useDirWatch";

const char CvsConfig::RemoteBrowser[]		= "/lincvs/remoteBrowser";
const char CvsConfig::LocalBrowser[]	        = "/lincvs/localBrowser";
const char CvsConfig::CVSRsh[]                  = "/lincvs/cvsRsh";
const char CvsConfig::LocalShell[]              = "/lincvs/localShell";
const char CvsConfig::DirPopupMenu[]            = "/lincvs/dirPopupMenu";
const char CvsConfig::FilePopupMenu[]           = "/lincvs/filePopupMenu";
const char CvsConfig::KeyboarsShortcuts[]       = "/lincvs/keyboardShortcuts";
const char CvsConfig::OpenFileList[]            = "/lincvs/openFileList";
const char CvsConfig::ViewFileList[]            = "/lincvs/viewFileList";
const char CvsConfig::ScanOnTheFly[]            = "/lincvs/scanOnTheFly";
const char CvsConfig::ScanNonCvs[]              = "/lincvs/scanNonCvs";
const char CvsConfig::AskForQuit[]              = "/lincvs/askForQuit";
const char CvsConfig::CvsIgnoreFiles[]          = "/lincvs/cvsIgnoreFiles";
const char CvsConfig::BinaryFileSpecList[]      = "/lincvs/binaryFileSpec";
const char CvsConfig::UseExternalDiff[]         = "/lincvs/useExternalDiffForSideBySide";
const char CvsConfig::ExtDiffProgram[]          = "/lincvs/externalDiffProgram";
const char CvsConfig::HistSizeComments[]        = "/lincvs/historySizeComments";
const char CvsConfig::HistSizeWorkdirs[]        = "/lincvs/historySizeWorkdirs";
const char CvsConfig::HistSizeProfiles[]        = "/lincvs/historySizeProfiles";

const char CvsConfig::GeomX[]			= "/lincvs/Geometry/geomX";
const char CvsConfig::GeomY[]			= "/lincvs/Geometry/geomY";
const char CvsConfig::GeomWidth[]		= "/lincvs/Geometry/geomWidth";
const char CvsConfig::GeomHeight[]		= "/lincvs/Geometry/geomHeight";
const char CvsConfig::SplitterPosH[]		= "/lincvs/Geometry/splitterPosH";
const char CvsConfig::SplitterPosV[]		= "/lincvs/Geometry/splitterPosV";
const char CvsConfig::WorkbenchColumnWidth[]	= "/lincvs/Geometry/workbenchColumnWidth";
const char CvsConfig::ToolbarPos[]              = "/lincvs/Geometry/ToolbarPosition";
const char CvsConfig::FileHeaderPos[]           = "/lincvs/Geometry/FileHeaderPosition";

const char CvsConfig::IconDir[]                 = "/lincvs/Looknfeel/iconDir";
const char CvsConfig::ColorRevA[]               = "/lincvs/Looknfeel/colorRevisionA";
const char CvsConfig::ColorRevB[]               = "/lincvs/Looknfeel/colorRevisionB";
const char CvsConfig::UseStandardDialogs[]      = "/lincvs/Looknfeel/useStdDialogs";
const char CvsConfig::DateTimeOrder[]           = "/lincvs/Looknfeel/DateTimeOrder";
const char CvsConfig::DateTimeFormat[]          = "/lincvs/Looknfeel/DateTimeFormat";

const char CvsConfig::Compression[]		= "/lincvs/CvsGlobal/compression";
const char CvsConfig::RwPermission[]            = "/lincvs/CvsGlobal/RwPermission";
const char CvsConfig::VirtualInFiletab[]        = "/lincvs/CvsGlobal/virtualInFileTab";
const char CvsConfig::DiffPrecision[]           = "/lincvs/CvsGlobal/diffPrecision";
const char CvsConfig::UnifiedDiffOutput[]       = "/lincvs/CvsGlobal/unifiedDiffOutput";

const char CvsConfig::PruneDirs[]               = "/lincvs/CvsSubcommands/pruneDirs";
const char CvsConfig::BringOverNewDirs[]        = "/lincvs/CvsSubcommands/bringOverNewDirs";
const char CvsConfig::KeywordSuppression[]      = "/lincvs/CvsSubcommands/keywordSuppression";
const char CvsConfig::IgnoreWhiteSpace[]        = "/lincvs/CvsSubcommands/diffIgnoreWhiteSpace";
const char CvsConfig::HistoryPeriod[]           = "/lincvs/CvsSubcommands/historyPeriod";
const char CvsConfig::Quiet[]                   = "/lincvs/CvsSubcommands/quiet";

const char CvsConfig::UserList[]                = "/lincvs/CvsServer/users";
const char CvsConfig::ServerList[]              = "/lincvs/CvsServer/servers";
const char CvsConfig::RepositoryList[]          = "/lincvs/CvsServer/repositories";
const char CvsConfig::ProfileList[]             = "/lincvs/CvsServer/profiles";
const char CvsConfig::XProfileList[]            = "/lincvs/CvsServer/xprofiles";
const char CvsConfig::ModuleList[]              = "/lincvs/CvsServer/modules";
const char CvsConfig::WorkdirList[]             = "/lincvs/CvsServer/workDirs";
const char CvsConfig::CheckoutAsList[]          = "/lincvs/CvsServer/checkoutAs";
const char CvsConfig::ProxyList[]               = "/lincvs/CvsServer/proxys";

const char CvsConfig::Projects[]                = "/lincvs/Projects";

const char CvsConfig::UseSyntaxHighlight[]      = "/lincvs/SyntaxHighlight/UseSyntaxHighlight";
const char CvsConfig::SynHighQuestionMarkStyle[]= "/lincvs/SyntaxHighlight/SynHighQuestionMarkStyle";
const char CvsConfig::SynHighQuestionMarkRgb[]  = "/lincvs/SyntaxHighlight/SynHighQuestionMarkRgb";
const char CvsConfig::SynHighModifiedStyle[]    = "/lincvs/SyntaxHighlight/SynHighModifiedStyle";
const char CvsConfig::SynHighModifiedRgb[]      = "/lincvs/SyntaxHighlight/SynHighModifiedRgb";
const char CvsConfig::SynHighNeedsUpdateStyle[] = "/lincvs/SyntaxHighlight/SynHighNeedsUpdateStyle";
const char CvsConfig::SynHighNeedsUpdateRgb[]   = "/lincvs/SyntaxHighlight/SynHighNeedsUpdateRgb";
const char CvsConfig::SynHighMergingStyle[]     = "/lincvs/SyntaxHighlight/SynHighMergingStyle";
const char CvsConfig::SynHighMergingRgb[]       = "/lincvs/SyntaxHighlight/SynHighMergingRgb";
const char CvsConfig::SynHighConflictStyle[]    = "/lincvs/SyntaxHighlight/SynHighConflictStyle";
const char CvsConfig::SynHighConflictRgb[]      = "/lincvs/SyntaxHighlight/SynHighConflictRgb";
const char CvsConfig::SynHighAddedStyle[]       = "/lincvs/SyntaxHighlight/SynHighAddedStyle";
const char CvsConfig::SynHighAddedRgb[]         = "/lincvs/SyntaxHighlight/SynHighAddedRgb";
const char CvsConfig::SynHighRemovedStyle[]     = "/lincvs/SyntaxHighlight/SynHighRemovedStyle";
const char CvsConfig::SynHighRemovedRgb[]       = "/lincvs/SyntaxHighlight/SynHighRemovedRgb";
const char CvsConfig::SynHighRemovedByOtherStyle[]= "/lincvs/SyntaxHighlight/SynHighRemovedByOtherStyle";
const char CvsConfig::SynHighRemovedByOtherRgb[]  = "/lincvs/SyntaxHighlight/SynHighRemovedByOtherRgb";
const char CvsConfig::SynHighDiffOldStyle[]     = "/lincvs/SyntaxHighlight/SynHighDiffOldStyle";
const char CvsConfig::SynHighDiffOldRgb[]       = "/lincvs/SyntaxHighlight/SynHighDiffOldRgb";
const char CvsConfig::SynHighDiffNewStyle[]     = "/lincvs/SyntaxHighlight/SynHighDiffNewStyle";
const char CvsConfig::SynHighDiffNewRgb[]       = "/lincvs/SyntaxHighlight/SynHighDiffNewRgb";

const char CvsConfig::FontGeneral[]             = "/lincvs/Font/General";
const char CvsConfig::FontMessage[]             = "/lincvs/Font/Message";
const char CvsConfig::FontDiff[]                = "/lincvs/Font/Diff";

const char CvsConfig::TextEncoder[]             = "/lincvs/I18n/TextEncoder";
const char CvsConfig::TextDecoder[]             = "/lincvs/I18n/TextDecoder";

const char CvsConfig::defCvsVersion[]           = "cvs";
#ifdef Q_WS_MAC
const char CvsConfig::defRemoteBrowser[]	= "open";
const char CvsConfig::defLocalBrowser[]		= "open";
const char CvsConfig::defOpenFileList[]         = "*\nopen\n%n\n-";
const char CvsConfig::defViewFileList[]         = "*\nopen\n%n\n-";
const char CvsConfig::defLocalShell[]           = "/Applications/Utilities/Terminal";
#else
#ifdef Q_WS_X11
const char CvsConfig::defRemoteBrowser[]	= "mozilla";
const char CvsConfig::defLocalBrowser[]		= "mozilla";
const char CvsConfig::defOpenFileList[]         = "*\nxterm\n-e vi %1\n-";
const char CvsConfig::defViewFileList[]         = "*\nxterm\n-e more %1\n-";
const char CvsConfig::defLocalShell[]           = "xterm";
#else
#ifdef Q_WS_QWS
const char CvsConfig::defRemoteBrowser[]	= "";
const char CvsConfig::defLocalBrowser[]		= "";
const char CvsConfig::defOpenFileList[]         = "";
const char CvsConfig::defViewFileList[]         = "";
const char CvsConfig::defLocalShell[]           = "";
#endif
#endif
#endif
const char CvsConfig::defCvsRsh[]               = "ssh";
const char CvsConfig::defCvsIgnoreFiles[]       = "RCS SCCS CVS CVS.adm RCSLOG cvslog.* tags TAGS .make.state .nse.depinfo *~ #* .#* ,* _$* *$ *.old *.bak *.BAK *.orig *.rej .del-* *.a *.olb *.o *.obj *.so *.exe *.Z *.elc *.ln core";

#ifdef Q_WS_MAC
const char CvsConfig::defKeyboarsShortcuts[]     = "4,12582980:7,8388677:8,4194373:10,4194392:11,4194376:12,12582984:15,8388684:16,4194384:18,8388689:25,4194386:29,4194388:30,8388692:33,4194389:34,8388693:46,12582991:47,4194370:48,4194387:54,4194371:55,8388694:59,4194372:83,4194385:";
#else
const char CvsConfig::defKeyboarsShortcuts[]     = "4,12582980:7,8388677:8,4194373:10,4194392:11,4194376:12,12582984:15,8388684:16,4194384:18,8388689:25,4194386:29,4194388:30,8388692:33,4194389:34,8388693:46,12582991:47,4194370:48,4194387:54,4194371:55,8388694:59,4194372:62,4194385:";
#endif

//----------------------------------------------------------------------------

/*!	Initialize the cvs configuration with the default values.
	\brief c'tor
*/
#ifndef Q_WS_WIN
CvsConfig::CvsConfig()
{
    m_pSettings = new QSettings();
    readCfg();
}
#endif
//----------------------------------------------------------------------------

/*!	Free all resources.
	\brief d'tor
*/
CvsConfig::~CvsConfig()
{
    writeCfg();
    delete m_pSettings;
}

//----------------------------------------------------------------------------

void CvsConfig::readCfg()
{
    /*! Section external apps */
   readExtApps();
   
    /*! Section GENERAL */
    DIRPOPUPMENU  = dirPopupMenu(); 
    FILEPOPUPMENU = filePopupMenu();
    KEYBOARDSHORTCUTS = getKeyboardShortcuts();
    OPENFILELIST  = getOpenFileList();
    VIEWFILELIST  = getViewFileList();

    if (bOVERRIDEONTHEFLYSCANNING) {//startup option
      ONTHEFLYSCANNING = true;
    } else {
      ONTHEFLYSCANNING = getOnTheFlyScanning();
    }
    bSCANNONCVS = getScanNonCvs();
    bAskForQuit = askForQuit();
    CVSIGNOREFILES = cvsIgnoreFiles();
    BINARYFILESPECLIST = getBinaryFileSpecList();

    bUSEEXTERNALDIFFFORSIDEBYSIDE = useExtDiff(); 

    Debug::g_bDebug         = debug();
    Debug::g_logLevel       = logLevel();
    DirWatch::b_useDirWatch = getUseDirWatch();
    CVSVERSION              = getCvsVersion();
    CVSPATH                 = getCvsPath();
    CVSPASSPATH             = getCvsPassPath();

    /*! Section TIMER */
    CHECKSTATUSINTERVALL = checkStatusIntervall();
    Polling::checkStatusLevel = getCheckStatusLevel();
    PROGRESSINTERVALL    = progressIntervall();

    /*! Section AutoUpdate */
    AUTOUPDATE = getAutoUpdate();
    AUTOUPDATEINTERVALL = getAutoUpdateIntervall();

    HistorySize::g_workdirs   = historySizeWorkdirs();
    HistorySize::g_profiles   = historySizeProfiles();
    HistorySize::g_commitinfo = historySizeComments();

    iconDir = iconDirectory();

    int rgbColor = colorRev(false);   //Revision A
    SELECTION_COLOR_OF_LOGDLG[0] = QColor(rgbColor);
    rgbColor = colorRev(true);        //Revision B
    SELECTION_COLOR_OF_LOGDLG[1] = QColor(rgbColor);

    /*! Section LookAndFeel */
    LookAndFeel::g_stdDlg = getStdDlg();
    LookAndFeel::g_dateTimeOrder = static_cast<QDateEdit::Order>(getDateTimeOrder());
    LookAndFeel::g_dateTimeFormat = getDateTimeFormat();

    /*! SECTION GEOMETRY */
    QRect geom        = geometry();
    GEOM_X            = geom.x();
    GEOM_Y            = geom.y();
    GEOM_WIDTH        = geom.width();
    GEOM_HEIGHT       = geom.height();

    SPLITTER_POS_H    = splitterPosH();
    SPLITTER_POS_V    = splitterPosV();
    WORKBENCH_COLUMN_WIDTH           = workbenchColumnWidth();
    TOOLBARPOS                          = getToolbarPos();
    SizeProperties::g_fileHeader = getFileHeaderPos();

    /*! SECTION SyntaxHighlight */
    HighlightProperties::g_bUseSyntaxHighlighting   = getUseSyntaxHighlighting();
    HighlightProperties::g_updateQuestionMark.style = getQuestionMarkStyle();
    HighlightProperties::g_updateQuestionMark.color = getQuestionMarkColor();
    HighlightProperties::g_updateModified.style     = getModifiedStyle();
    HighlightProperties::g_updateModified.color     = getModifiedColor();
    HighlightProperties::g_updateNeedsUpdate.style  = getNeedsUpdateStyle();
    HighlightProperties::g_updateNeedsUpdate.color  = getNeedsUpdateColor();
    HighlightProperties::g_updateMerging.style      = getMergingStyle();
    HighlightProperties::g_updateMerging.color      = getMergingColor();
    HighlightProperties::g_updateConflict.style     = getConflictStyle();
    HighlightProperties::g_updateConflict.color     = getConflictColor();
    HighlightProperties::g_updateAdded.style        = getAddedStyle();
    HighlightProperties::g_updateAdded.color        = getAddedColor();
    HighlightProperties::g_updateRemoved.style      = getRemovedStyle();
    HighlightProperties::g_updateRemoved.color      = getRemovedColor();
    HighlightProperties::g_updateRemovedByOther.style = getRemovedByOtherStyle();
    HighlightProperties::g_updateRemovedByOther.color = getRemovedByOtherColor();
    HighlightProperties::g_diffOld.style            = getDiffOldStyle();
    HighlightProperties::g_diffOld.color            = getDiffOldColor();
    HighlightProperties::g_diffNew.style            = getDiffNewStyle();
    HighlightProperties::g_diffNew.color            = getDiffNewColor();

    /*! SECTION Font */
    Font::g_general = getFontGeneral();
    Font::g_message = getFontMessage();
    Font::g_diff    = getFontDiff();
    
    /*! SECTION I18n */
    I18n::g_nameOfEncoder = getTextEncoder();
    I18n::g_nameOfDecoder = getTextDecoder();

    /*! SECTION CvsGlobal */
    CvsOptions::g_compression = compression();
    bRWPermission = rwPermission();
    CvsOptions::g_bShowVirtualInFiletab = getShowVirtualInFiletab();
    CvsOptions::g_precision = getDiffPrecision();
    CvsOptions::g_bUnifiedDiffOutput = getUnifiedDiffOutput();

    /*! SECTION CvsSubcommands */
    CvsOptions::g_bPruneDirs = pruneDirs();
    CvsOptions::g_bBringOverNewDirs = bringOverNewDirs();
    bKeywordSuppression = keywordSuppression();
    bDiffIgnoreWhiteSpace = getIgnoreWhiteSpace();
    CvsOptions::g_historyPeriod = getHistoryPeriod();
    CvsOptions::g_bQuietCvs = getQuiet();

    /*! SECTION CvsServer */
    cvsUsers           = userList();
    cvsServers         = serverList();
    cvsRepositories    = repositoryList();
    MODULEHISTORYLIST  = moduleList();
    WORKDIRHISTORYLIST = workdirList();  //list of locale dirs of working copy
    CHECKOUTASLIST     = getCheckoutAsList();
    proxyList          = getProxyList();

    //read profile list, generate *namelist and *contentlist...
    readProfiles(xprofileList());

    simplifyStringList(&cvsServers);
    simplifyStringList(&cvsRepositories);
    simplifyStringList(&cvsUsers);
    simplifyStringList(&MODULEHISTORYLIST);
    simplifyStringList(&WORKDIRHISTORYLIST);

    //project settings
    if (!bStartedInDir) {//startup option
      readProjectSettings( Projects);
    }

    QString lastVersion = m_pSettings->readEntry(Version, "");
    if (lastVersion < getVersion()) {
      updateVersionOnRead(lastVersion,getVersion());
    } else {
      m_needUpdate = FALSE;
    }
}

//----------------------------------------------------------------------------

void CvsConfig::writeCfg()
{
    if (m_needUpdate) {
      QString lastVersion = m_pSettings->readEntry(Version, "");
      updateVersionOnWrite(lastVersion,getVersion());
      m_pSettings->writeEntry(Version, getVersion());
      m_needUpdate = FALSE;
    }

    bool res;

    /*! Section GENERAL */
    writeExtApps();

    setDirPopupMenu(DIRPOPUPMENU); 
    setFilePopupMenu(FILEPOPUPMENU);
    setKeyboardShortcuts(KEYBOARDSHORTCUTS);
    setOpenFileList(OPENFILELIST);
    setViewFileList(VIEWFILELIST);

    if (!bOVERRIDEONTHEFLYSCANNING) {//startup option
      setOnTheFlyScanning(ONTHEFLYSCANNING);
    }
    setScanNonCvs(bSCANNONCVS);
    setAskForQuit(bAskForQuit);
    setCvsIgnoreFiles(CVSIGNOREFILES);
    setBinaryFileSpecList(BINARYFILESPECLIST);

    setUseExtDiff(bUSEEXTERNALDIFFFORSIDEBYSIDE); 
    
    setDebug(Debug::g_bDebug);
    setLogLevel(Debug::g_logLevel);
    setCvsVersion(CVSVERSION);
    setUseDirWatch(DirWatch::b_useDirWatch);
    setCvsPath(CVSPATH);
    setCvsPassPath(CVSPASSPATH);

    setHistorySizeWorkdirs(HistorySize::g_workdirs);
    setHistorySizeProfiles(HistorySize::g_profiles);
    setHistorySizeComments(HistorySize::g_commitinfo);

    /*! Section TIMER */
    res = setCheckStatusIntervall(CHECKSTATUSINTERVALL);
    setCheckStatusLevel(Polling::checkStatusLevel);
    res = setProgressIntervall(PROGRESSINTERVALL);

    /*! Section AutoUpdate */
    setAutoUpdate(AUTOUPDATE);
    setAutoUpdateIntervall(AUTOUPDATEINTERVALL);

    setIconDirectory(iconDir);

    setColorRev(false, SELECTION_COLOR_OF_LOGDLG[0].rgb());
    setColorRev(true , SELECTION_COLOR_OF_LOGDLG[1].rgb());

    /*! Section LookAndFeel */
    setStdDlg(LookAndFeel::g_stdDlg);
    setDateTimeOrder(LookAndFeel::g_dateTimeOrder);
    setDateTimeFormat(LookAndFeel::g_dateTimeFormat);

    /*! Geometry */
    QRect geom(GEOM_X, GEOM_Y, GEOM_WIDTH, GEOM_HEIGHT);
    setGeometry(geom);

    setSplitterPosH(SPLITTER_POS_H);
    setSplitterPosV(SPLITTER_POS_V);
    setWorkbenchColumnWidth(WORKBENCH_COLUMN_WIDTH);
    setToolbarPos(TOOLBARPOS);
    setFileHeaderPos(SizeProperties::g_fileHeader);

    /*! SECTION SyntaxHighlight */
    setUseSyntaxHighlighting(HighlightProperties::g_bUseSyntaxHighlighting);
    setQuestionMarkStyle(HighlightProperties::g_updateQuestionMark.style);
    setQuestionMarkColor(HighlightProperties::g_updateQuestionMark.color);
    setModifiedStyle(HighlightProperties::g_updateModified.style);
    setModifiedColor(HighlightProperties::g_updateModified.color);
    setNeedsUpdateStyle(HighlightProperties::g_updateNeedsUpdate.style);
    setNeedsUpdateColor(HighlightProperties::g_updateNeedsUpdate.color);
    setMergingStyle(HighlightProperties::g_updateMerging.style);
    setMergingColor(HighlightProperties::g_updateMerging.color);
    setConflictStyle(HighlightProperties::g_updateConflict.style);
    setConflictColor(HighlightProperties::g_updateConflict.color);
    setAddedStyle(HighlightProperties::g_updateAdded.style);
    setAddedColor(HighlightProperties::g_updateAdded.color);
    setRemovedStyle(HighlightProperties::g_updateRemoved.style);
    setRemovedColor(HighlightProperties::g_updateRemoved.color);
    setRemovedByOtherStyle(HighlightProperties::g_updateRemovedByOther.style);
    setRemovedByOtherColor(HighlightProperties::g_updateRemovedByOther.color);
    setDiffOldStyle(HighlightProperties::g_diffOld.style);
    setDiffOldColor(HighlightProperties::g_diffOld.color);
    setDiffNewStyle(HighlightProperties::g_diffNew.style);
    setDiffNewColor(HighlightProperties::g_diffNew.color);

    /*! SECTION Font */
    setFontGeneral(Font::g_general);
    setFontMessage(Font::g_message);
    setFontDiff(Font::g_diff); 

    /*! SECTION I18n */
    setTextEncoder(I18n::g_nameOfEncoder);
    setTextDecoder(I18n::g_nameOfDecoder);

    /*! SECTION CvsGlobal */
    setCompression(CvsOptions::g_compression);
    setRwPermission(bRWPermission);
    setShowVirtualInFiletab(CvsOptions::g_bShowVirtualInFiletab);
    setDiffPrecision(CvsOptions::g_precision);
    setUnifiedDiffOutput(CvsOptions::g_bUnifiedDiffOutput);

    /*! SECTION CvsSubcommands */
    setPruneDirs(CvsOptions::g_bPruneDirs);    
    setBringOverNewDirs(CvsOptions::g_bBringOverNewDirs);    
    setKeywordSuppression(bKeywordSuppression);
    setIgnoreWhiteSpace(bDiffIgnoreWhiteSpace);
    setHistoryPeriod(CvsOptions::g_historyPeriod);
    setQuiet(CvsOptions::g_bQuietCvs);

    /*! SECTION CvsServer */
    simplifyStringList(&cvsUsers);
    cutList(&cvsUsers, HistorySize::g_profiles);
    setUserList(cvsUsers);

    simplifyStringList(&cvsServers);
    cutList(&cvsServers, HistorySize::g_profiles);
    setServerList(cvsServers);
    
    simplifyStringList(&cvsRepositories);
    cutList(&cvsRepositories, HistorySize::g_profiles);
    setRepositoryList(cvsRepositories);

    setModuleList(MODULEHISTORYLIST);
    setWorkdirList(WORKDIRHISTORYLIST);
    setCheckoutAsList(CHECKOUTASLIST);
    setProxyList(proxyList);

    //save profile content
    QStringList tmpList;
    QValueList<CLincvsProfile>::const_iterator itPro;
    for (itPro = cvsProfileContentList.begin(); itPro != cvsProfileContentList.end(); itPro++) {
        QString line, strSshClientPreset;
        line.setNum((*itPro).method());
        strSshClientPreset.setNum((*itPro).sshClientPreset());
        line = (*itPro).name().stripWhiteSpace() + "," + line;
        line += "," + (*itPro).user().stripWhiteSpace();
        line += "," + (*itPro).server();
        line += "," + (*itPro).repository();
        line += "," + strSshClientPreset;

        tmpList.append(line);
    }

    setxProfileList(tmpList);

    //Project settings
    if (!bStartedInDir) {//startup option
      writeProjectSettings( Projects);
    }
}

//----------------------------------------------------------------------------

void CvsConfig::readProjectSettings( QString projectPath) {

  unsigned int i = 0;
  QStringList projectList = m_pSettings->subkeyList( projectPath);

  if (projectList.isEmpty()) {//fallback to old project settings model, will be removed in near future

    QStringList projectNameList     = m_pSettings->readListEntry("/lincvs/Workbench/projectList");
    QStringList projectDisabledList = m_pSettings->readListEntry("/lincvs/Workbench/projectDisabledList");

    for( i = 0; i < projectNameList.count(); i++) {

#ifdef Q_WS_WIN
      projectNameList[i].replace(QRegExp ("\\\\"), "/");
#endif
      QString projectName = projectNameList[i].mid(projectNameList[i].findRev("/")+1);
      projectSettings->set( projectName,WORKDIR,projectNameList[i]);
      
      QStringList::iterator it;
      QStringList disabled;
      for ( it = projectDisabledList.begin(); it != projectDisabledList.end(); ++it ) {
	if ((*it).startsWith(projectNameList[i]) &&
	    ( ((*it).length() == projectNameList[i].length()) ||
	      ((*it).at(projectNameList[i].length())=='/'))) {

	  disabled.append(*it);

	}
      }
      projectSettings->set( projectName,DISABLED,disabled);
    }
    return;
  }

  projectSettings->readFromSettings( m_pSettings, projectPath);

}

//----------------------------------------------------------------------------

void CvsConfig::writeProjectSettings( QString projectPath) {

  unsigned int i = 0;
  QStringList oldSettings = m_pSettings->subkeyList( projectPath);
  
  QStringList projectList;
  projectSettings->getProjects( projectList);
  
  for( i = 0; i < projectList.count(); i++) {
    
    QStringList::iterator it = oldSettings.find(projectList[i]);
    if (it != oldSettings.end()) {
      oldSettings.remove(it);
    }
    
  }
  for( i = 0; i < oldSettings.count(); i++) {
    QString key = QString(projectPath)+"/"+oldSettings[i];
    removeProjectSettings( key);
  }
  projectSettings->writeToSettings(m_pSettings,projectPath);

  //remove old project settings model list
  m_pSettings->removeEntry("/lincvs/Workbench/projectList");
  m_pSettings->removeEntry("/lincvs/Workbench/projectDisabledList");

//     projectSettings->test();

}

//----------------------------------------------------------------------------

void CvsConfig::removeProjectSettings( QString key) {

  QStringList projectSubKeys = m_pSettings->entryList( key);//delete all subkeys

  unsigned int i = 0;
  for( i = 0; i < projectSubKeys.count(); i++) {
    const QString subKey = key+"/"+projectSubKeys[i];
    m_pSettings->removeEntry(subKey);
  }
}

//----------------------------------------------------------------------------

void CvsConfig::updateVersionOnRead( const QString& oldVersion, const QString& newVersion) {

  qDebug(QObject::tr("Detected old LinCVS resource file")
	 +",\n"
	 + QObject::tr("updating from LinCVS version: ")
	 +QString(oldVersion.isEmpty() ? QObject::tr("unknown") : oldVersion)
	 +"\n"
	 +QObject::tr("to new version: ")+newVersion);

  m_needUpdate = FALSE;
  bool updated = FALSE;

  if (oldVersion <= QString("1.3.1")) {
    qDebug(QObject::tr("Update in progress"));
    
    readProfiles(profileList());  // read old profiles list
    simplifyStringList(&cvsServers);
    simplifyStringList(&cvsRepositories);
    simplifyStringList(&cvsUsers);

    m_needUpdate = TRUE;
    updated = TRUE;
  }

  if (!updated) qDebug(QObject::tr("No update required"));

}

//----------------------------------------------------------------------------

void CvsConfig::updateVersionOnWrite( const QString& oldVersion, const QString& newVersion) {

  bool updated = FALSE;
  if (oldVersion <= QString("1.2.1")) {//clear toplevel-disabled-list if subprojects exist

    unsigned int i;
    QStringList disabledList;
    QStringList topLevelProjectNameList;
    QStringList subProjectNameList;
    
    projectSettings->getTopLevelProjects(topLevelProjectNameList);
    for (i=0; i<topLevelProjectNameList.count(); ++i) {
      if (projectSettings->getSubProjects(topLevelProjectNameList[i],subProjectNameList) && !subProjectNameList.isEmpty()) {
	projectSettings->set(topLevelProjectNameList[i],DISABLED,disabledList);
      }
    }

    updated = TRUE;
  }
  if (oldVersion <= QString("1.3.1")) {
     updated = TRUE;
  }

  if (updated) qDebug(QObject::tr("Update to:")+" "+newVersion+" "+QObject::tr("succeeded"));
  if (!updated) qDebug(QObject::tr("No update required"));

}

//----------------------------------------------------------------------------

void CvsConfig::readExtApps()
{
   QString tmpExtApp;
   int pos;
    
   tmpExtApp = localShell(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_localShell.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_localShell.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_localShell.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_localShell.options = QString::null;
   }
      
   tmpExtApp = localBrowser(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_localBrowser.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_localBrowser.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_localBrowser.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_localBrowser.options = QString::null;
   }
   
   tmpExtApp = remoteBrowser(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_remoteBrowser.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_remoteBrowser.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_remoteBrowser.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_remoteBrowser.options = QString::null;
   }

   tmpExtApp = CvsRsh(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_cvsRsh.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_cvsRsh.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_cvsRsh.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_cvsRsh.options = QString::null;
   }
   //at the moment we don't use options for cvsRsh
   ExtApps::g_cvsRsh.options = QString::null;

   tmpExtApp = extDiffProgram(); pos = tmpExtApp.find("\n");
   if (pos >= 0) {
      ExtApps::g_diffProg.path = tmpExtApp.left(pos).stripWhiteSpace();
      ExtApps::g_diffProg.options = tmpExtApp.right(tmpExtApp.length() - pos).stripWhiteSpace();
   } else {
      ExtApps::g_diffProg.path = tmpExtApp.stripWhiteSpace();
      ExtApps::g_diffProg.options = QString::null;
   }
}

//----------------------------------------------------------------------------

void CvsConfig::writeExtApps()
{
   setLocalShell(ExtApps::g_localShell.path + "\n" + ExtApps::g_localShell.options);
   setLocalBrowser(ExtApps::g_localBrowser.path + "\n" + ExtApps::g_localBrowser.options);
   setRemoteBrowser(ExtApps::g_remoteBrowser.path + "\n" + ExtApps::g_remoteBrowser.options);
   setCvsRsh(ExtApps::g_cvsRsh.path + "\n" + ExtApps::g_cvsRsh.options);
   setExtDiffProgram(ExtApps::g_diffProg.path + "\n" + ExtApps::g_diffProg.options);
}
 
//----------------------------------------------------------------------------

void CvsConfig::readProfiles(QStringList tmpList)
{
    cvsProfileContentList.clear();

    /*! insert items from qstringlist into a qlist */
    QStringList::Iterator it;
    for ( it = tmpList.begin(); it != tmpList.end(); ++it ) {
        QString line = (*it);
        line.prepend (',');
        line.append  (',');
// qDebug(line);

        unsigned int i, idx, oldidx;
        idx = oldidx = 0;
        i = 0;
        const unsigned int nbItems = 6;
        QString lItem[nbItems + 1];  // one more for the overlast empty item
        
        /*! separate items */
        do {
            oldidx = idx+1;
            idx = line.find (',', oldidx); // WARNING: -1 --> 2^[32|64]
            lItem[i++] = line.mid(oldidx, idx-oldidx);
        } while ((idx < line.length()) && (i < nbItems)); // terminate also if more items than expected
        
        /*! add item to qlist */
        int sshClientPreset = NOSSH;
        if (!lItem[5].isEmpty()) {
           sshClientPreset = lItem[5].stripWhiteSpace().toInt();
           if (sshClientPreset < NOSSH) sshClientPreset = NOSSH;
           else if (sshClientPreset > USESSHAGENTVARS) sshClientPreset = USESSHAGENTVARS;
        }
        cvsProfileContentList.append(CLincvsProfile(lItem[0].stripWhiteSpace(),
            lItem[1].stripWhiteSpace().toInt(),
            lItem[2].stripWhiteSpace(),
            lItem[3].stripWhiteSpace(),
            lItem[4].stripWhiteSpace(),
            sshClientPreset));
    }

    cvsProfileNameList.clear(); 

    QValueList<CLincvsProfile>::const_iterator itPro;
    for (itPro = cvsProfileContentList.begin(); itPro != cvsProfileContentList.end(); itPro++) {
        cvsProfileNameList.append((*itPro).name().stripWhiteSpace());
        cvsUsers.append((*itPro).user().stripWhiteSpace());
        cvsServers.append((*itPro).server().stripWhiteSpace());
        cvsRepositories.append((*itPro).repository().stripWhiteSpace());
    }
}

//----------------------------------------------------------------------------
