/* new_mixer.c
 *
 * Copyright (c) 1999 Scott Manley, Barath Raghavan, Jack Moffitt, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License  
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#include "mixer.h"
/* this is the "central multiplexer" for the mixer architechture            */
/* most of these commands are just big switch statments to do things        */
/* dpending on  the value of the Module_type                                */

void get_audio(Mod_Ptr *mod,short *dat){

  switch ( mod->Mod_Type ) {
  case MOD_NULL:
    mod_null_get(mod,dat);
    break;
  case MOD_THRU:
    mod_thru_get(mod,dat);
  default:
    mod_null(mod,dat);
  }

}



void mod_debug_dump(Mod_Ptr dat){
int i;
fprintf(stderr,"Module %s\n",set->name);
fprintf(stderr,"Module Type: %d\n",dat->Mod_Type);
fprintf(stderr,"Volume: %f\n",dat->volume);
fprintf(stderr,"Ints: %d   Floats: %d   Connections: %d\n",dat->num_ints,dat->num_floats,dat->num_connections);
fprintf(stderr,"Connections:\n"); 
 for(i=0;i<dat->num_connections;i++)
   {
   if(set->connections[i]!=NULL)
     fprintf(stderr,"%d: %s %X\n",i,set->connections[i]->name,set->connections[i]);
   else
     fprintf(stderr,"%d: Not Defined\n");
   }
 if(set->num_ints>0){
   fprintf(stderr,"Integer Parameters:\n");
   for(i=0;i<set->num_ints;i++){
     fprintf(stderr,"%d: %d\n",set->param_i[i]);
   }
 }
 if(set->num_floats>0){
   fprintf(stderr,"Float Parameters:\n");
   for(i=0;i<set->num_floats;i++){
     fprintf(stderr,"%d: %d\n",set->param_f[i]);
   }
 }
}

void new_mixer(config *conf){
Format fmt;
Mod_Struct *input;
int adat[BUF_SIZE];

input=create_mixer();
 while(1){
   get_audio(input,adat);
 }


}
