/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.management.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.InterceptorStack;
import org.apache.hivemind.ServiceInterceptorFactory;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.internal.ServicePoint;
import org.apache.hivemind.management.MBeanRegistry;
import org.apache.hivemind.management.ManagementMessages;
import org.apache.hivemind.management.ObjectNameBuilder;
import org.apache.hivemind.management.impl.PerformanceCollector;
import org.apache.hivemind.management.mbeans.PerformanceMonitorMBean;
import org.apache.hivemind.methodmatch.MethodMatcher;
import org.apache.hivemind.service.MethodContribution;
import org.apache.hivemind.service.MethodIterator;
import org.apache.hivemind.service.MethodSignature;

public class PerformanceMonitorFactory
implements ServiceInterceptorFactory {
    private static final String SERVICE_DECORATOR_TYPE = "PerformanceCollector";
    private MBeanRegistry _mbeanRegistry;
    private ObjectNameBuilder _objectNameBuilder;
    private String _serviceId;

    public PerformanceMonitorFactory(MBeanRegistry mbeanRegistry, ObjectNameBuilder objectNameBuilder) {
        this._mbeanRegistry = mbeanRegistry;
        this._objectNameBuilder = objectNameBuilder;
    }

    public void setServiceId(String string) {
        this._serviceId = string;
    }

    public void createInterceptor(InterceptorStack stack, Module invokingModule, List parameters) {
        ServicePoint servicePoint = invokingModule.getServicePoint(stack.getServiceExtensionPointId());
        Set methods = this.getInterceptedMethods(stack, parameters);
        try {
            PerformanceCollector counter = this.createMBean(servicePoint, methods);
            PerformanceMonitorHandler countHandler = new PerformanceMonitorHandler(stack.peek(), counter, methods);
            Object proxy = Proxy.newProxyInstance(invokingModule.getClassResolver().getClassLoader(), new Class[]{stack.getServiceInterface()}, (InvocationHandler)countHandler);
            stack.push(proxy);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ManagementMessages.errorInstantiatingPerformanceInterceptor(this._serviceId, stack, ex), (Throwable)ex);
        }
    }

    public PerformanceCollector createMBean(ServicePoint servicePoint, Set methods) throws JMException {
        PerformanceMonitorMBean counter = new PerformanceMonitorMBean(methods);
        ObjectName objectName = this._objectNameBuilder.createServiceDecoratorName(servicePoint, SERVICE_DECORATOR_TYPE);
        this._mbeanRegistry.registerMBean(counter, null, objectName);
        return counter;
    }

    private MethodMatcher buildMethodMatcher(List parameters) {
        MethodMatcher result = null;
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            MethodContribution mc = (MethodContribution)i.next();
            if (result == null) {
                result = new MethodMatcher();
            }
            result.put(mc.getMethodPattern(), (Object)mc);
        }
        return result;
    }

    protected Set getInterceptedMethods(InterceptorStack stack, List parameters) {
        HashSet<MethodSignature> methods = new HashSet<MethodSignature>();
        MethodMatcher matcher = this.buildMethodMatcher(parameters);
        MethodIterator mi = new MethodIterator(stack.getServiceInterface());
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            if (!this.includeMethod(matcher, sig)) continue;
            methods.add(sig);
        }
        return methods;
    }

    private boolean includeMethod(MethodMatcher matcher, MethodSignature sig) {
        if (matcher == null) {
            return true;
        }
        MethodContribution mc = (MethodContribution)matcher.get(sig);
        return mc == null || mc.getInclude();
    }

    private class PerformanceMonitorHandler
    implements InvocationHandler {
        private Object _inner;
        private PerformanceCollector _counter;
        private Set _interceptedMethods;

        PerformanceMonitorHandler(Object inner, PerformanceCollector counter, Set interceptedMethods) {
            this._inner = inner;
            this._counter = counter;
            this._interceptedMethods = interceptedMethods;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                MethodSignature signature = new MethodSignature(method);
                if (this._interceptedMethods.contains(signature)) {
                    long startTime = System.currentTimeMillis();
                    Object result = method.invoke(this._inner, args);
                    long endTime = System.currentTimeMillis();
                    this._counter.addMeasurement(signature, endTime - startTime);
                    return result;
                }
                return method.invoke(this._inner, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

