/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;

public class HessianDebugInputStream
extends InputStream {
    private InputStream _is;
    private PrintWriter _dbg;
    private State _state;
    private ArrayList<State> _stateStack = new ArrayList();
    private int _refId;

    public HessianDebugInputStream(InputStream is, PrintWriter dbg) {
        this._is = is;
        this._dbg = dbg;
        this._state = new InitialState();
    }

    public int read() throws IOException {
        InputStream is = this._is;
        if (is == null) {
            return -1;
        }
        int ch = is.read();
        this._state = this._state.next(ch);
        return ch;
    }

    public void close() throws IOException {
        InputStream is = this._is;
        this._is = null;
        this._dbg = null;
        if (is != null) {
            is.close();
        }
    }

    void println(String string) {
        this.println(0, string);
    }

    void println(int depth, String string) {
        for (int i = 0; i < this._stateStack.size() + depth - 1; ++i) {
            this._dbg.print("  ");
        }
        this._dbg.println(string);
        this._dbg.flush();
    }

    void pushStack(State state) {
        this._stateStack.add(state);
    }

    State popStack() {
        return this._stateStack.remove(this._stateStack.size() - 1);
    }

    class RemoteState
    extends State {
        private static final int TYPE = 0;
        private static final int VALUE = 1;
        private static final int END = 2;
        private int _state;
        private int _major;
        private int _minor;

        RemoteState() {
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    HessianDebugInputStream.this.println(-1, "remote");
                    if (ch == 116) {
                        this._state = 1;
                        HessianDebugInputStream.this.pushStack(this);
                        return new StringState('t', false);
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 1: {
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 2: {
                    return HessianDebugInputStream.this.popStack().next(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class ReplyState
    extends State {
        private static final int MAJOR = 0;
        private static final int MINOR = 1;
        private static final int HEADER = 2;
        private static final int VALUE = 3;
        private static final int END = 4;
        private int _state;
        private int _major;
        private int _minor;

        ReplyState() {
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    if (ch == 116 || ch == 83) {
                        return new RemoteState().next(ch);
                    }
                    this._major = ch;
                    this._state = 1;
                    return this;
                }
                case 1: {
                    this._minor = ch;
                    this._state = 2;
                    HessianDebugInputStream.this.println(-1, new CharBuffer().append("reply ").append(this._major).append(".").append(this._minor).toString());
                    return this;
                }
                case 2: {
                    if (ch == 72) {
                        this._state = 3;
                        HessianDebugInputStream.this.pushStack(this);
                        return new StringState('H', true);
                    }
                    if (ch == 102) {
                        HessianDebugInputStream.this.println("f: fault");
                        this._state = 4;
                        return new MapState();
                    }
                    this._state = 4;
                    return this.nextObject(ch);
                }
                case 3: {
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 4: {
                    return HessianDebugInputStream.this.popStack().next(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class CallState
    extends State {
        private static final int MAJOR = 0;
        private static final int MINOR = 1;
        private static final int HEADER = 2;
        private static final int VALUE = 3;
        private static final int ARG = 4;
        private int _state;
        private int _major;
        private int _minor;

        CallState() {
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    this._major = ch;
                    this._state = 1;
                    return this;
                }
                case 1: {
                    this._minor = ch;
                    this._state = 2;
                    HessianDebugInputStream.this.println(-1, new CharBuffer().append("call ").append(this._major).append(".").append(this._minor).toString());
                    return this;
                }
                case 2: {
                    if (ch == 72) {
                        this._state = 3;
                        HessianDebugInputStream.this.pushStack(this);
                        return new StringState('H', true);
                    }
                    if (ch == 109) {
                        this._state = 4;
                        HessianDebugInputStream.this.pushStack(this);
                        return new StringState('m', true);
                    }
                    HessianDebugInputStream.this.println(new CharBuffer().append((char)ch).append(": unexpected char").toString());
                    return HessianDebugInputStream.this.popStack();
                }
                case 3: {
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 4: {
                    if (ch == 122) {
                        return HessianDebugInputStream.this.popStack();
                    }
                    return this.nextObject(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class ListState
    extends State {
        private static final int TYPE = 0;
        private static final int LENGTH = 1;
        private static final int VALUE = 2;
        private int _state;

        ListState() {
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    if (ch == 122) {
                        return HessianDebugInputStream.this.popStack();
                    }
                    if (ch == 116) {
                        this._state = 1;
                        HessianDebugInputStream.this.pushStack(this);
                        return new StringState('t', true);
                    }
                    if (ch == 108) {
                        this._state = 2;
                        HessianDebugInputStream.this.pushStack(this);
                        return new IntegerState("l");
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 1: {
                    if (ch == 122) {
                        return HessianDebugInputStream.this.popStack();
                    }
                    if (ch == 108) {
                        this._state = 2;
                        HessianDebugInputStream.this.pushStack(this);
                        return new IntegerState("len");
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 2: {
                    if (ch == 122) {
                        return HessianDebugInputStream.this.popStack();
                    }
                    return this.nextObject(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class MapState
    extends State {
        private static final int TYPE = 0;
        private static final int KEY = 1;
        private static final int VALUE = 2;
        private int _state;

        MapState() {
        }

        State next(int ch) {
            switch (this._state) {
                case 0: {
                    if (ch == 116) {
                        this._state = 1;
                        HessianDebugInputStream.this.pushStack(this);
                        return new StringState('t', true);
                    }
                    if (ch == 122) {
                        return HessianDebugInputStream.this.popStack();
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 1: {
                    if (ch == 122) {
                        return HessianDebugInputStream.this.popStack();
                    }
                    this._state = 2;
                    return this.nextObject(ch);
                }
                case 2: {
                    this._state = 1;
                    return this.nextObject(ch);
                }
            }
            throw new IllegalStateException();
        }
    }

    class ByteState
    extends State {
        int _lengthIndex;
        int _length;
        boolean _isLastChunk;

        ByteState(boolean isLastChunk) {
            this._isLastChunk = isLastChunk;
        }

        State next(int ch) {
            if (this._lengthIndex < 2) {
                this._length = 256 * this._length + (ch & 0xFF);
                if (++this._lengthIndex == 2) {
                    if (this._isLastChunk) {
                        HessianDebugInputStream.this.println(new CharBuffer().append("B: ").append(this._length).toString());
                    } else {
                        HessianDebugInputStream.this.println(new CharBuffer().append("b: ").append(this._length).toString());
                    }
                }
                if (this._lengthIndex == 2 && this._length == 0 && this._isLastChunk) {
                    return HessianDebugInputStream.this.popStack();
                }
                return this;
            }
            if (this._length == 0) {
                if (ch == 98) {
                    this._isLastChunk = false;
                    this._lengthIndex = 0;
                    return this;
                }
                if (ch == 66) {
                    this._isLastChunk = true;
                    this._lengthIndex = 0;
                    return this;
                }
                HessianDebugInputStream.this.println(new CharBuffer().append(String.valueOf((char)ch)).append(": unexpected character").toString());
                return HessianDebugInputStream.this.popStack();
            }
            --this._length;
            if (this._length == 0) {
                return HessianDebugInputStream.this.popStack();
            }
            return this;
        }
    }

    class StringState
    extends State {
        private static final int TOP = 0;
        private static final int UTF_2_1 = 1;
        private static final int UTF_3_1 = 2;
        private static final int UTF_3_2 = 3;
        char _typeCode;
        CharBuffer _value;
        int _lengthIndex;
        int _length;
        boolean _isLastChunk;
        int _utfState;
        char _ch;

        StringState(char typeCode, boolean isLastChunk) {
            this._value = new CharBuffer();
            this._typeCode = typeCode;
            this._isLastChunk = isLastChunk;
        }

        State next(int ch) {
            if (this._lengthIndex < 2) {
                this._length = 256 * this._length + (ch & 0xFF);
                if (++this._lengthIndex == 2 && this._length == 0 && this._isLastChunk) {
                    HessianDebugInputStream.this.println(new CharBuffer().append(this._typeCode).append(": ").append((Object)this._value).toString());
                    return HessianDebugInputStream.this.popStack();
                }
                return this;
            }
            if (this._length == 0) {
                if (ch == 115 || ch == 120) {
                    this._isLastChunk = false;
                    this._lengthIndex = 0;
                    return this;
                }
                if (ch == 83 || ch == 88) {
                    this._isLastChunk = true;
                    this._lengthIndex = 0;
                    return this;
                }
                HessianDebugInputStream.this.println(new CharBuffer().append(String.valueOf((char)ch)).append(": unexpected character").toString());
                return HessianDebugInputStream.this.popStack();
            }
            switch (this._utfState) {
                case 0: {
                    if (ch < 128) {
                        --this._length;
                        this._value.append((char)ch);
                        break;
                    }
                    if (ch < 224) {
                        this._ch = (char)((ch & 0x1F) << 6);
                        this._utfState = 1;
                        break;
                    }
                    this._ch = (char)((ch & 0xF) << 12);
                    this._utfState = 2;
                    break;
                }
                case 1: 
                case 3: {
                    this._ch = (char)(this._ch + (ch & 0x3F));
                    this._value.append(this._ch);
                    --this._length;
                    this._utfState = 0;
                    break;
                }
                case 2: {
                    this._ch = (char)(this._ch + (char)((ch & 0x3F) << 6));
                    this._utfState = 3;
                }
            }
            if (this._length == 0) {
                HessianDebugInputStream.this.println(new CharBuffer().append(this._typeCode).append(": ").append((Object)this._value).toString());
                return HessianDebugInputStream.this.popStack();
            }
            return this;
        }
    }

    class DoubleState
    extends State {
        int _length;
        long _value;

        DoubleState() {
        }

        State next(int ch) {
            this._value = 256L * this._value + (long)(ch & 0xFF);
            if (++this._length == 8) {
                HessianDebugInputStream.this.println(new CharBuffer().append("D: ").append(Double.longBitsToDouble(this._value)).toString());
                return HessianDebugInputStream.this.popStack();
            }
            return this;
        }
    }

    class DateState
    extends State {
        int _length;
        long _value;

        DateState() {
        }

        State next(int ch) {
            this._value = 256L * this._value + (long)(ch & 0xFF);
            if (++this._length == 8) {
                HessianDebugInputStream.this.println(new CharBuffer().append("d: ").append(new Date(this._value)).toString());
                return HessianDebugInputStream.this.popStack();
            }
            return this;
        }
    }

    class LongState
    extends State {
        int _length;
        long _value;

        LongState() {
        }

        State next(int ch) {
            this._value = 256L * this._value + (long)(ch & 0xFF);
            if (++this._length == 8) {
                HessianDebugInputStream.this.println(new CharBuffer().append("L: ").append(this._value).toString());
                return HessianDebugInputStream.this.popStack();
            }
            return this;
        }
    }

    class IntegerState
    extends State {
        String _typeCode;
        int _length;
        int _value;

        IntegerState(String typeCode) {
            this._typeCode = typeCode;
        }

        State next(int ch) {
            this._value = 256 * this._value + (ch & 0xFF);
            if (++this._length == 4) {
                HessianDebugInputStream.this.println(new CharBuffer().append(this._typeCode).append(": ").append(this._value).toString());
                return HessianDebugInputStream.this.popStack();
            }
            return this;
        }
    }

    class ObjectState
    extends State {
        ObjectState() {
        }

        State next(int ch) {
            return this.nextObject(ch);
        }
    }

    class InitialState
    extends State {
        InitialState() {
        }

        State next(int ch) {
            if (ch == 114) {
                HessianDebugInputStream.this.pushStack(this);
                return new ReplyState();
            }
            if (ch == 99) {
                HessianDebugInputStream.this.pushStack(this);
                return new CallState();
            }
            return this.nextObject(ch);
        }
    }

    abstract class State {
        State() {
        }

        abstract State next(int var1);

        protected State nextObject(int ch) {
            switch (ch) {
                case -1: {
                    return this;
                }
                case 78: {
                    HessianDebugInputStream.this.println(1, "N: null");
                    return this;
                }
                case 84: {
                    HessianDebugInputStream.this.println(1, "T: true");
                    return this;
                }
                case 70: {
                    HessianDebugInputStream.this.println(1, "F: false");
                    return this;
                }
                case 73: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new IntegerState("I");
                }
                case 82: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new IntegerState("Ref");
                }
                case 114: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new RemoteState();
                }
                case 76: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new LongState();
                }
                case 100: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new DateState();
                }
                case 68: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new DoubleState();
                }
                case 83: 
                case 88: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new StringState('S', true);
                }
                case 115: 
                case 120: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new StringState('S', false);
                }
                case 66: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new ByteState(true);
                }
                case 98: {
                    HessianDebugInputStream.this.pushStack(this);
                    return new ByteState(false);
                }
                case 77: {
                    HessianDebugInputStream.this.println(1, new CharBuffer().append("M: map/object #").append(HessianDebugInputStream.this._refId++).toString());
                    HessianDebugInputStream.this.pushStack(this);
                    return new MapState();
                }
                case 86: {
                    HessianDebugInputStream.this.println(1, new CharBuffer().append("V: list #").append(HessianDebugInputStream.this._refId++).toString());
                    HessianDebugInputStream.this.pushStack(this);
                    return new ListState();
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    return this;
                }
            }
            HessianDebugInputStream.this.println(new CharBuffer().append(String.valueOf((char)ch)).append(": unexpected character").toString());
            return this;
        }
    }
}

