/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.service.impl;

import java.util.Iterator;
import org.apache.hivemind.service.ThreadCleanupListener;
import org.apache.hivemind.service.ThreadEventNotifier;
import org.apache.hivemind.util.EventListenerList;

public class ThreadEventNotifierImpl
implements ThreadEventNotifier {
    private ThreadLocal _storage = new ThreadLocal();

    public void addThreadCleanupListener(ThreadCleanupListener listener) {
        EventListenerList list = (EventListenerList)this._storage.get();
        if (list == null) {
            list = new EventListenerList();
            this._storage.set(list);
        }
        list.addListener(listener);
    }

    public void removeThreadCleanupListener(ThreadCleanupListener listener) {
        EventListenerList list = (EventListenerList)this._storage.get();
        if (list != null) {
            list.removeListener(listener);
        }
    }

    public void fireThreadCleanup() {
        EventListenerList list = (EventListenerList)this._storage.get();
        if (list == null) {
            return;
        }
        Iterator i = list.getListeners();
        while (i.hasNext()) {
            ThreadCleanupListener listener = (ThreadCleanupListener)i.next();
            listener.threadDidCleanup();
        }
    }
}

