/*
 * Decompiled with CFR 0.152.
 */
package javassist.preproc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.preproc.Assistant;
import javassist.preproc.CommentSkipper;

public class Compiler {
    protected BufferedReader input;
    protected BufferedWriter output;
    protected ClassPool classPool;

    public Compiler(String inputname) throws CannotCompileException {
        try {
            this.input = new BufferedReader(new FileReader(inputname));
        }
        catch (IOException e) {
            throw new CannotCompileException("cannot open: " + inputname);
        }
        String outputname = this.getOutputFilename(inputname);
        if (outputname.equals(inputname)) {
            throw new CannotCompileException("invalid source name: " + inputname);
        }
        try {
            this.output = new BufferedWriter(new FileWriter(outputname));
        }
        catch (IOException e) {
            throw new CannotCompileException("cannot open: " + outputname);
        }
        this.classPool = ClassPool.getDefault();
    }

    public void process() throws IOException, CannotCompileException {
        int c;
        CommentSkipper reader = new CommentSkipper(this.input, this.output);
        while ((c = reader.read()) != -1) {
            this.output.write(c);
            if (c == 112) {
                if (!this.skipPackage(reader)) continue;
                break;
            }
            if (c == 105) {
                this.readImport(reader);
                continue;
            }
            if (c == 32 || c == 9 || c == 10 || c == 13) continue;
        }
        while ((c = this.input.read()) != -1) {
            this.output.write(c);
        }
        this.input.close();
        this.output.close();
    }

    private boolean skipPackage(CommentSkipper reader) throws IOException {
        int c = reader.read();
        this.output.write(c);
        if (c != 97) {
            return true;
        }
        while ((c = reader.read()) != -1) {
            this.output.write(c);
            if (c != 59) continue;
            break;
        }
        return false;
    }

    private void readImport(CommentSkipper reader) throws IOException, CannotCompileException {
        int[] word = new int[5];
        for (int i = 0; i < 5; ++i) {
            word[i] = reader.read();
            this.output.write(word[i]);
        }
        if (word[0] != 109 || word[1] != 112 || word[2] != 111 || word[3] != 114 || word[4] != 116) {
            return;
        }
        int c = this.skipSpaces(reader, 32);
        StringBuffer classbuf = new StringBuffer();
        while (c != 32 && c != 9 && c != 10 && c != 13 && c != 59 && c != -1) {
            classbuf.append((char)c);
            c = reader.read();
        }
        String importclass = classbuf.toString();
        if ((c = this.skipSpaces(reader, c)) == 59) {
            this.output.write(importclass);
            this.output.write(59);
            return;
        }
        if (c != 98) {
            this.syntaxError(importclass);
        }
        reader.read();
        StringBuffer assistant = new StringBuffer();
        Vector args = new Vector();
        c = this.readAssistant(reader, importclass, assistant, args);
        c = this.skipSpaces(reader, c);
        if (c != 59) {
            this.syntaxError(importclass);
        }
        this.runAssistant(importclass, assistant.toString(), args);
    }

    void syntaxError(String importclass) throws CannotCompileException {
        throw new CannotCompileException("Syntax error.  Cannot import " + importclass);
    }

    int readAssistant(CommentSkipper reader, String importclass, StringBuffer assistant, Vector args) throws IOException, CannotCompileException {
        int c = this.readArgument(reader, assistant);
        if ((c = this.skipSpaces(reader, c)) == 40) {
            do {
                StringBuffer arg = new StringBuffer();
                c = this.readArgument(reader, arg);
                args.addElement(arg.toString());
            } while ((c = this.skipSpaces(reader, c)) == 44);
            if (c != 41) {
                this.syntaxError(importclass);
            }
            return reader.read();
        }
        return c;
    }

    int readArgument(CommentSkipper reader, StringBuffer buf) throws IOException {
        int c = this.skipSpaces(reader, 32);
        while (65 <= c && c <= 90 || 97 <= c && c <= 122 || 48 <= c && c <= 57 || c == 46 || c == 95) {
            buf.append((char)c);
            c = reader.read();
        }
        return c;
    }

    int skipSpaces(CommentSkipper reader, int c) throws IOException {
        while (c == 32 || c == 9 || c == 10 || c == 13) {
            if (c == 10 || c == 13) {
                this.output.write(c);
            }
            c = reader.read();
        }
        return c;
    }

    private void runAssistant(String importname, String assistantname, Vector argv) throws IOException, CannotCompileException {
        Assistant a;
        Class<?> assistant;
        int s = argv.size();
        String[] args = new String[s];
        for (int i = 0; i < s; ++i) {
            args[i] = (String)argv.elementAt(i);
        }
        try {
            assistant = Class.forName(assistantname);
        }
        catch (ClassNotFoundException e) {
            throw new CannotCompileException("Cannot find " + assistantname);
        }
        try {
            a = (Assistant)assistant.newInstance();
        }
        catch (Exception e) {
            throw new CannotCompileException(e);
        }
        CtClass[] imports = a.assist(this.classPool, importname, args);
        s = imports.length;
        if (s < 1) {
            this.output.write(" java.lang.Object;");
        } else {
            this.output.write(32);
            this.output.write(imports[0].getName());
            this.output.write(59);
            for (int i = 1; i < s; ++i) {
                this.output.write(" import ");
                this.output.write(imports[1].getName());
                this.output.write(59);
            }
        }
    }

    private String getOutputFilename(String input) {
        int i = input.lastIndexOf(46);
        if (i < 0) {
            i = input.length();
        }
        return input.substring(0, i) + ".java";
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                Compiler c = new Compiler(args[0]);
                c.process();
            }
            catch (IOException e) {
                System.err.println(e);
            }
            catch (CannotCompileException e) {
                System.err.println(e);
            }
        } else {
            System.err.println("Javassist version 3.0");
            System.err.println("No source file is specified.");
        }
    }
}

