/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.easymock.ArgumentsMatcher;
import org.easymock.MockControl;
import org.easymock.internal.AssertionFailedErrorWrapper;
import org.easymock.internal.IBehavior;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;

public abstract class AbstractBehavior
implements IBehavior {
    private ArgumentsMatcher defaultMatcher;
    private boolean defaultMatcherSet;
    private Map<Method, ArgumentsMatcher> matchers = new HashMap<Method, ArgumentsMatcher>();
    private Map<Method, Result> defaultResults = new HashMap<Method, Result>();

    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        if (this.defaultMatcherSet) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("default matcher can only be set once directly after creation of the MockControl"));
        }
        this.defaultMatcher = matcher;
        this.defaultMatcherSet = true;
    }

    public void setMatcher(Method method, ArgumentsMatcher matcher) {
        if (this.matchers.containsKey(method) && this.matchers.get(method) != matcher) {
            throw new RuntimeExceptionWrapper(new IllegalStateException("for method " + method.getName() + "(" + (method.getParameterTypes().length == 0 ? "" : "...") + "), a matcher has already been set"));
        }
        this.matchers.put(method, matcher);
    }

    public void setDefaultResult(Method method, Result result) {
        this.defaultResults.put(method, result);
    }

    public final Result addActual(MethodCall methodCall) {
        try {
            return this.doAddActual(methodCall);
        }
        catch (AssertionFailedErrorWrapper e) {
            throw new AssertionFailedErrorWrapper(new AssertionFailedError("\n  Unexpected method call " + methodCall.toString(this.getMatcher(methodCall.getMethod())) + ":" + e.getAssertionFailedError().getMessage()));
        }
    }

    public final void verify() {
        try {
            this.doVerify();
        }
        catch (AssertionFailedErrorWrapper e) {
            throw new AssertionFailedErrorWrapper(new AssertionFailedError("\n  Expectation failure on verify:" + e.getAssertionFailedError().getMessage()));
        }
    }

    protected Result getDefaultResult(Method method) {
        return this.defaultResults.get(method);
    }

    protected ArgumentsMatcher getMatcher(Method method) {
        if (!this.matchers.containsKey(method)) {
            if (!this.defaultMatcherSet) {
                this.setDefaultMatcher(MockControl.EQUALS_MATCHER);
            }
            this.matchers.put(method, this.defaultMatcher);
        }
        return this.matchers.get(method);
    }

    protected abstract void doVerify();

    protected abstract Result doAddActual(MethodCall var1);
}

