/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.easymock.AbstractMatcher;

public class ArrayMatcher
extends AbstractMatcher {
    public String argumentToString(Object argument) {
        if (argument != null && argument.getClass().isArray()) {
            return this.arrayToString(ArrayMatcher.createObjectArray(argument));
        }
        return super.argumentToString(argument);
    }

    private String arrayToString(Object[] array) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(super.argumentToString(array[i]));
            if (i == array.length - 1) continue;
            result.append(", ");
        }
        return "[" + result.toString() + "]";
    }

    public boolean argumentMatches(Object expected, Object actual) {
        if (expected instanceof boolean[]) {
            return Arrays.equals((boolean[])expected, (boolean[])actual);
        }
        if (expected instanceof byte[]) {
            return Arrays.equals((byte[])expected, (byte[])actual);
        }
        if (expected instanceof char[]) {
            return Arrays.equals((char[])expected, (char[])actual);
        }
        if (expected instanceof double[]) {
            return Arrays.equals((double[])expected, (double[])actual);
        }
        if (expected instanceof float[]) {
            return Arrays.equals((float[])expected, (float[])actual);
        }
        if (expected instanceof int[]) {
            return Arrays.equals((int[])expected, (int[])actual);
        }
        if (expected instanceof long[]) {
            return Arrays.equals((long[])expected, (long[])actual);
        }
        if (expected instanceof short[]) {
            return Arrays.equals((short[])expected, (short[])actual);
        }
        if (expected instanceof Object[]) {
            return Arrays.equals((Object[])expected, (Object[])actual);
        }
        return super.argumentMatches(expected, actual);
    }

    public static Object[] createObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        Object[] result = new Object[Array.getLength(array)];
        for (int i = 0; i < Array.getLength(array); ++i) {
            result[i] = Array.get(array, i);
        }
        return result;
    }
}

