/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.easymock.internal.AbstractBehavior;
import org.easymock.internal.AssertionFailedErrorWrapper;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.ResultListMap;

public class UnorderedBehavior
extends AbstractBehavior {
    private Map<Method, ResultListMap> methodBehaviors = new HashMap<Method, ResultListMap>();

    private ResultListMap getMethodBehavior(Method method) {
        if (!this.methodBehaviors.containsKey(method)) {
            this.methodBehaviors.put(method, new ResultListMap(method, this.getMatcher(method)));
        }
        return this.methodBehaviors.get(method);
    }

    public void addExpected(MethodCall call, Result returnValue, Range range) {
        ResultListMap behaviors = this.getMethodBehavior(call.getMethod());
        behaviors.addExpected(call.getArguments(), returnValue, range);
    }

    protected Result returnValueForUnexpected(Method method) {
        return null;
    }

    public Result doAddActual(MethodCall methodCall) {
        ResultListMap behavior = this.getMethodBehavior(methodCall.getMethod());
        try {
            return behavior.addActual(methodCall.getArguments());
        }
        catch (AssertionFailedErrorWrapper e) {
            Result defaultBehavior = this.getDefaultResult(methodCall.getMethod());
            if (defaultBehavior != null) {
                return defaultBehavior;
            }
            Result niceBehavior = this.returnValueForUnexpected(methodCall.getMethod());
            if (niceBehavior != null) {
                return niceBehavior;
            }
            throw e;
        }
    }

    public void doVerify() {
        String failureMessage = "";
        boolean verifyFailed = false;
        for (Method method : this.methodBehaviors.keySet()) {
            try {
                this.getMethodBehavior(method).verify();
            }
            catch (AssertionFailedError e) {
                verifyFailed = true;
                failureMessage = failureMessage + e.getMessage();
            }
        }
        if (!verifyFailed) {
            return;
        }
        throw new AssertionFailedErrorWrapper(new AssertionFailedError(failureMessage));
    }
}

