package com.icl.saxon.exslt;
import com.icl.saxon.expr.*;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.NodeEnumeration;
import java.util.Vector;

/**
* This class implements extension functions in the
* http://exslt.org/math namespace. <p>
*/

public abstract class Math  {

    /**
    * Get the maximum numeric value of the string-value of each of a set of nodes
    */

    public static double max (NodeEnumeration nsv) throws XPathException {
        double max = Double.NEGATIVE_INFINITY;
        while (nsv.hasMoreElements()) {
            double x = Value.stringToNumber(nsv.nextElement().getStringValue());
            if (Double.isNaN(x)) return x;
            if (x>max) max = x;
        }
        return max;
    }


    /**
    * Get the minimum numeric value of the string-value of each of a set of nodes
    */

    public static double min (NodeEnumeration nsv) throws XPathException {
        double min = Double.POSITIVE_INFINITY;
        while (nsv.hasMoreElements()) {
            double x = Value.stringToNumber(nsv.nextElement().getStringValue());
            if (Double.isNaN(x)) return x;
            if (x<min) min = x;
        }
        return min;
    }


    /**
    * Get the nodes with maximum numeric value of the string-value of each of a set of nodes
    */

    public static NodeSetValue highest (Context c, NodeEnumeration nsv) throws XPathException {
        double max = Double.NEGATIVE_INFINITY;
        Vector highest = new Vector();
        while (nsv.hasMoreElements()) {
            NodeInfo node = nsv.nextElement();
            double x = Value.stringToNumber(node.getStringValue());
            if (Double.isNaN(x)) return new EmptyNodeSet();
            if (x==max) {
                highest.addElement(node);
            } else if (x>max) {
                max = x;
                highest.removeAllElements();
                highest.addElement(node);
            }
        }
        return new NodeSetExtent(highest, c.getController());
    }



    /**
    * Get the node with minimum numeric value of the string-value of each of a set of nodes
    */

    public static NodeSetValue lowest (Context c, NodeEnumeration nsv) throws XPathException {
        double min = Double.POSITIVE_INFINITY;
        Vector lowest = new Vector();
        while (nsv.hasMoreElements()) {
            NodeInfo node = nsv.nextElement();
            double x = Value.stringToNumber(node.getStringValue());
            if (Double.isNaN(x)) return new EmptyNodeSet();
            if (x==min) {
                lowest.addElement(node);
            } else if (x<min) {
                min = x;
                lowest.removeAllElements();
                lowest.addElement(node);
            }
        }
        return new NodeSetExtent(lowest, c.getController());
    }

}





//
// The contents of this file are subject to the Mozilla Public License Version 1.0 (the "License");
// you may not use this file except in compliance with the License. You may obtain a copy of the
// License at http://www.mozilla.org/MPL/ 
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the License for the specific language governing rights and limitations under the License. 
//
// The Original Code is: all this file. 
//
// The Initial Developer of the Original Code is
// Michael Kay of International Computers Limited (mhkay@iclway.co.uk).
//
// Portions created by (your name) are Copyright (C) (your legal entity). All Rights Reserved. 
//
// Contributor(s): none. 
//
