/* FileFilters.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui;

import be.ugent.caagt.swirl.actions.ExtensionFileFilter;
import java.util.ResourceBundle;

/**
 * Several file filters which are used throughout the system
 */
public final class FileFilters {
    
    //
    private static final String BUNDLE_NAME = "org.grinvin.gui.resources";
    

    /**
     * Filter for invariant computer class files.
     */
    public static final ExtensionFileFilter INVARIANT_FILTER;

    /**
     * Filter for Grinvin graphs.
     */
    public static final ExtensionFileFilter GPH_FILTER;
    
    /**
     * Filter for graph6 graphs.
     */
    public static final ExtensionFileFilter G6_FILTER;
    
    /**
     * Filter for Grinvin graphlists
     */
    public static final ExtensionFileFilter GRAPHLIST_FILTER;
    
    /**
     * Filter for graph6 graph lists.
     */
    public static final ExtensionFileFilter G6_LIST_FILTER;
    
    /**
     * Filter for grinvin workspace files.
     */
    public static final ExtensionFileFilter GWS_FILTER;
    
    /**
     * Filter for grinvin workspace folders.
     */
    public static final ExtensionFileFilter WORKSPACE_FILTER;
    
    /**
     * Filter for svg images.
     */
    public static final ExtensionFileFilter SVG_FILTER;
    

    static {
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        INVARIANT_FILTER = new ExtensionFileFilter ("class", 
                bundle.getString("filter.invariant.description"));
        GPH_FILTER = new ExtensionFileFilter("gph", 
                bundle.getString("filter.gph.description"));
        G6_FILTER  = new ExtensionFileFilter("g6" , 
                bundle.getString("filter.g6.description"));
        GRAPHLIST_FILTER = new ExtensionFileFilter("graphlist", 
                bundle.getString("filter.graphlist.description"));
        G6_LIST_FILTER  = new ExtensionFileFilter("g6" , 
                bundle.getString("filter.g6list.description"));
        GWS_FILTER = new ExtensionFileFilter("gws", 
                bundle.getString("filter.gws.description"));
        WORKSPACE_FILTER = new ExtensionFileFilter("workspace", 
                bundle.getString("filter.workspace.description"));
        SVG_FILTER = new ExtensionFileFilter("svg", 
                bundle.getString("filter.svg.description"));
    }
 }
