/* SchultzIndex.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.chemical;

import org.grinvin.GraphBundleView;
import org.grinvin.invariants.IntegerValue;
import org.grinvin.invariants.computers.AbstractInvariantComputer;

/**
 * computes the Schultz index of the graph.
 */
public class SchultzIndex extends AbstractInvariantComputer {
    
    public IntegerValue compute(GraphBundleView bundle) {
        int[][] distanceMatrix = bundle.distanceMatrix();
        boolean[][] adjacencyMatrix = bundle.booleanAdjacencyMatrix();
        int[][] adjlist = bundle.adjacencyList();
        int n = adjlist.length;
        if (n == 0)
            return IntegerValue.undefinedValue(this);
        
        int schultzIndex = 0;
        boolean connected = true;
        for(int i = 0; i < n; i++)
            for(int j = 0; j < n; j++) {
                schultzIndex += (distanceMatrix[i][j] + (adjacencyMatrix[i][j] ? 1 : 0))*adjlist[j].length;
                connected = connected && !(distanceMatrix[i][j]==0 && j != i);
            }
        if(connected)
            return new IntegerValue(schultzIndex, this);
        else
            return IntegerValue.undefinedValue(this);
    }
    
    public String getInvariantId() {
        return "org.grinvin.invariants.SchultzIndex";
    }
}
