/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.metadata.retrieval.test;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.annotation.InstanceAnnotation;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;
import org.jboss.test.metadata.AbstractMetaDataTest;
import org.jboss.test.metadata.retrieval.support.SimpleMBean;
import org.jboss.test.metadata.retrieval.support.SimpleMBean2;
import org.jboss.test.metadata.retrieval.support.TestJMXImpl;

/**
 * MarkupAnnotationsTestCase.
 * <p/>
 * Test annotations that markup additional behavior:
 * - @org.jboss.metadata.spi.annotation.InstanceAnnotation
 *
 * @author <a href="ales.justin@jboss.com">Ales Justin</a>
 */
public class MarkupAnnotationsTestCase extends AbstractMetaDataTest
{
   public MarkupAnnotationsTestCase(String name)
   {
      super(name);
   }

   protected MetaData getClassMetaData(Class<?> clazz)
   {
      AnnotatedElementMetaDataLoader loader = new AnnotatedElementMetaDataLoader(clazz);
      return new MetaDataRetrievalToMetaDataBridge(loader);
   }

   protected boolean hasMetaDataAtInstanceLevel(MetaData metaData)
   {
      if (metaData != null && metaData.isEmpty() == false)
      {
         Set<Object> checkSet = new HashSet<Object>();
         Object[] allMetaData = metaData.getMetaData();
         Annotation[] annotations = metaData.getAnnotations();

         checkSet.addAll(Arrays.asList(allMetaData));
         checkSet.removeAll(Arrays.asList(annotations));

         // do we have something else than annotations
         if (checkSet.isEmpty() == false)
            return true;
         else
         {
            // do we have an annotation that's not marked with IA
            for (Annotation annotation : annotations)
            {
               InstanceAnnotation ia = annotation.annotationType().getAnnotation(InstanceAnnotation.class);
               if (ia == null || ia.value())
                  return true;
            }
         }
      }
      return false;
   }

   public void testInstanceAnnotation() throws Throwable
   {
      assertFalse(hasMetaDataAtInstanceLevel(getClassMetaData(SimpleMBean.class)));
      assertTrue(hasMetaDataAtInstanceLevel(getClassMetaData(SimpleMBean2.class)));

      MemoryMetaDataLoader mem1 = new MemoryMetaDataLoader();
      mem1.addAnnotation(new TestJMXImpl());
      mem1.addMetaData("foobar", String.class);
      MetaData md1 = new MetaDataRetrievalToMetaDataBridge(mem1);
      assertTrue(hasMetaDataAtInstanceLevel(md1));
   }
}