/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/


package org.jboss.remoting.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

/**
 * Controls the creation of ObjectInputStream, ObjectOutputStream.
 * <p/>
 * It is important that implementation of this class needs to be stateless.
 * $Id: SerializationManager.java,v 1.8 2006/07/07 20:29:59 csuconic Exp $
 *
 * @author <a href="mailto:tclebert.suconic@jboss.com">Clebert Suconic</a>
 */
public abstract class SerializationManager
{
   public ObjectInputStream createRegularInput(InputStream input) throws IOException
   {
      return createInput(input, Thread.currentThread().getContextClassLoader());
   }

   public abstract ObjectInputStream createInput(InputStream input, ClassLoader loader) throws IOException;

   public abstract ObjectOutputStream createOutput(OutputStream output) throws IOException;

   /**
    * Creates a MarshalledValue that does lazy serialization.
    */
   public abstract IMarshalledValue createdMarshalledValue(Object source) throws IOException;

   public abstract void sendObject(ObjectOutputStream output, Object dataObject) throws IOException;
   
   /** Used in call by value operations.
    * This will use the most effective way */
	public abstract IMarshalledValue createMarshalledValueForClone(Object original) throws IOException;

   /**
    * This was a refactory of a method usually existent on {@link org.jboss.remoting.marshal.serializable.SerializableUnMarshaller}.
    * That's why we are using InputStream instead of ObjectInputStream as a parameter here.
    */
   public abstract Object receiveObject(InputStream input, ClassLoader customClassLoader) throws IOException, ClassNotFoundException;
}
