/*


    @author DanielD

    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.procserver;

import java.io.*;

/**
 *
 */
public class Log
{
    private static Thread lastThread = null;
    private static PrintStream logStream = null;
    private static PrintStream logStream2 = null;
    public static final String defaultLogName = "java-procs.log";
    public static final String prefixC = "--- ";
    /**
     * hide, only static methods allowed
     */
    private
    Log ()
    {
    }
    /**
     *
     */
    static public void 
    open (
        String fname)
    throws IOException
    {
        Log.logStream = new PrintStream (new FileOutputStream (fname, false));        
        Log.logStream2 = System.out;
    }
    /**
     *
     */
    static public void 
    open ()
    throws IOException
    {
        open (defaultLogName);
    }
    /**
     *
     */
    static public void 
    close ()
    throws IOException
    {
        Log.logStream.close ();
        Log.logStream = null;
    }
    /**
     *
     */
    private static void checkThreadChange () {
        Thread t = Thread.currentThread ();
        if (t != lastThread) {
            lastThread = t;
            logStream.println ("");
            logStream.println ("---- Thread " + Integer.toHexString (t.hashCode ())
                    + " " + t.getName ()+" Timestamp: "+(new java.sql.Timestamp(System.currentTimeMillis())));
        }
    }
    /**
     *
     * @param text java.lang.String
     */
    static public synchronized void println (String text) {
        if (logStream != null) {
            checkThreadChange();
            logStream.println (text);
            if (logStream2 != null) {
                System.out.println (prefixC + text);
            }
        }
    }
    /**
     *
     * @param text java.lang.String
     */
    static public synchronized void print (String text) {
        if (logStream != null) {
            checkThreadChange();
            logStream.print (text);
        }
    }
    /**
     *
     */
    static public void 
    log (
        String text)
    {
        println (text);
    }
    /**
     *
     */
    static public void 
    logErr (
        String text)
    {
        println ("ERR:  " + text);
    }
    /**
     *
     */
    static public void 
    logTodo (
        String text)
    {
        println ("TODO: " + text);
    }
    /**
     *
     * @param exc java.lang.Throwable
     */
    public static synchronized void traceException (Throwable exc) {
        if (logStream != null) {
            checkThreadChange ();
            logStream.println ("Timestamp: "+(new java.sql.Timestamp(System.currentTimeMillis())));
            exc.printStackTrace (logStream);
            if (logStream2 != null) {
                exc.printStackTrace (System.out);
            }
        }
    }
    /**
     *
     */
    public static synchronized void
    whereAmI ()
    {
        if (logStream != null) {
            checkThreadChange ();
            log ("whereAmI in Log");
            Throwable thr = new Throwable();
            thr.printStackTrace(logStream);
            thr.printStackTrace(System.out);
        }
    }
    
}
