/*
This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA   02110-1301

see: http://www.fsf.org/licensing/licenses/gpl-howto.html
*/

/****************************************************************************
** ManDVD
**
** Created: Mon May 08 14:00:00 2006
**      by: Gibault Stphane
**	Hacked on by Mikael Bhm micko@bag.org
**
** This is a tool for simply creating DVD Video
** 
****************************************************************************/
//
// C++ Interface: 
//
// Description:  Global information general for complete program
//
//
// Author: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//


#ifndef MANDVD_GLOBAL_H
#define MANDVD_GLOBAL_H

/* Only holds choosen language at present */
#define CONFIGFILE 	"/.mandvdrc" 

/* The current version of ManDVD*/
#define MANDVDVER       "ManDVD v2.5-4"

/* Here is the current ManDVD homepage */
#define HOMEPG 		"http://www.kde-apps.org/content/show.php/ManDVD?content=83906\n"

#define PALDVD		"720x576"
#define PALSVCD		"480x576"
//#define PALCVD		"352x576"

//Change from 352x288 to 352x576 VCD is now really CVD
#define PALVCD		"352x576" 

#define NTSCDVD		"720x480"
#define NTSCSVCD	"480x480"

//Change from 352x240 to 252x480 
#define NTSCVCD		"252x480"


// VCDFORMAT (MPEG-1)
// NTSC = 352x240, 29,97fps
// PAL = 352x288, 25fps
// 
// SVCDFORMAT (MPEG-2)
// NTSC = 480x480, 29,97fps
// PAL = 480x576, 25fps
// 
// DVDFORMAT (MPEG-2)
// PAL = 352x576, 25fps
// PAL 16:9 = 720x576 25fps
// NTSC = 252x480 29,97fps
// NTSC 16:19 = 720x480 29,97fps


// PAL
// 
// Video:
// Up to 9.8 Mbps* (9800 kbps*) MPEG2 video
// Up to 1.856 Mbps (1856 kbps) MPEG1 video
// 720 x 576 pixels MPEG2 (Called Full-D1)
// 704 x 576 pixels MPEG2
// 352 x 576 pixels MPEG2 (Called Half-D1, same as the CVD Standard)
// 352 x 288 pixels MPEG2
// 352 x 288 pixels MPEG1 (Same as the VCD Standard)
// 25 fps*
// 16:9 Anamorphic (only supported by 720x576)


#define DEFAULTAUDIOBR	384


/*
** ATTENTION: Theese functions has to be manually declraed inside mainfrm.h incase it has be autogenerated
**            with gui builder QT3 Designer ! VERY IMPORTENT!!!!
*/

// virtual void bt_gener_struct_clicked();
// virtual void readFromStdout();
// virtual void fin_encode();
// virtual void stdout_menu();
// virtual void stdout_dvdauth();
// virtual void fin_genmenu();
// virtual void fin_totale();
// virtual void bt_lire_DVD_clicked();
// virtual void bt_grave_clicked();
// virtual void bt_annul_grave_clicked();
// virtual void bt_go_grave_clicked();
// virtual void fin_grave();
// virtual void stdout_grave();
// virtual void bt_valid_langue_clicked ();

// virtual void aboutdialog_Clicked();
// virtual void calculsize(int);
// virtual void fin_netttout();
// virtual void videostandard_highlighted(const QString&);
// virtual void toolButton72_clicked();
// virtual void toolButton72_2_clicked();
// virtual void bt_charg_wall_clicked();
// virtual void slider_x_valueChanged(int);
// virtual void slider_y_valueChanged(int);
// virtual void bt_valid_bt_clicked();
// virtual void bt_et04_con_2_clicked();
// virtual void bt_et03_con_2_clicked();
// virtual void bt_et03_con_clicked();
// virtual void add_video_clicked();
// virtual void bt_add_film_menu_clicked();
// virtual void bt_import_video_manim_clicked();
// virtual void bt_quit_clicked();
// virtual void goopenproj(QString);
// virtual void gosaveproj(QString);
// virtual void toolButton168_2_clicked();
// virtual void bt_save_1_clicked();
// virtual void toolButton71_clicked();
// virtual void bt_charg_wall_uni_clicked();
// virtual void bt_first_imganim_clicked();
// virtual void test_type_video_menuanim();
// virtual void bt_modif_gimp_clicked();
// virtual void fin_thegimp();
// virtual void bt_deb_menani_clicked();
// virtual void bt_fin_menani_clicked();
// virtual void bt_valid_menu_anim_clicked();
// virtual void changingframe_valueChanged(int);
// virtual void bt_add_photo_bt_clicked();
// virtual void bt_import_video_manim_2_clicked();
// virtual void btchauto_1_clicked();
// virtual void bt_valid_info_image_2_clicked();
// virtual void bt_valid_info_image_3_clicked();
// virtual void sliderpriorite_valueChanged(int);
// virtual void bt_add_img_slide_2_2_clicked();
// virtual void bt_valid_param_defo_clicked();
// virtual void bt_tab_order_clicked();
// virtual void bt_fermer_taborder_clicked();
// virtual void bt_down_tab_clicked();
// virtual void bt_up_ab_clicked();
// virtual void bt_param_encode_clicked();
// virtual void slidevbitrate_valueChanged(int);
// virtual void bt_grave_3_clicked();
// virtual void stdout_mkiso();
// virtual void fin_iso();
// virtual void bt_grave_2_clicked();
// virtual void affconsole_clicked();

// virtual void bt_fermer_slide_clicked();
// virtual void bt_add_img_slide_clicked();
// virtual void bt_gener_slideshow_clicked();
// virtual void stdout_diapo();
// virtual void fin_gendiapo();
// virtual void num_photo_valueChanged(int);
// virtual void casse_tout();
// virtual void bt_select_zik_clicked();
// virtual void gotrans();
// virtual void bt_annul_gener_slide_clicked();
// virtual void bt_start_gener_slide_clicked();
// virtual void bt_aff_con_diapo_clicked();
// virtual void bt_fond_mus_clicked();
// virtual void bt_affcach_con_grave_clicked();
// virtual void bt_choix_police_titre_clicked();
// virtual void bt_choix_couleur_titre_clicked();
// virtual void bt_add_img_slide_2_clicked();
// virtual void bt_create_fond_anim_clicked();
// virtual void bt_choix_couleur_titre_2_clicked();
// virtual bool eventFilter(QObject*, QEvent*);
// virtual void slider7_valueChanged(int);
// virtual void toolButton94_clicked();
// virtual void toolButton94_2_clicked();
// virtual void mylsteffets_doubleClicked(QIconViewItem*);
// virtual void toolButton95_clicked();
// virtual void toolButton97_clicked();
// virtual void fin_plus_effets();
// virtual void toolButton97_2_clicked();
// virtual void toolButton98_clicked();
// virtual void toolButton99_clicked();
// virtual void mylsttrans_doubleClicked(QIconViewItem*);
// virtual void duree_affichage_valueChanged(int);
// virtual void duree_transition_valueChanged(int);
// virtual void txt_img_textChanged(const QString&);
// virtual void bt_sup_chap_2_clicked();
// virtual void bt_force_clicked();
// virtual void valideditmask_clicked();
// virtual void bt_maskedit_clicked();
// virtual void outils0_clicked();
// virtual void outils1_clicked();
// virtual void keyPressEvent(QKeyEvent*);
// virtual void optsel2_stateChanged(int);
// virtual void optsel1_stateChanged(int);
// virtual void lstempl_clicked(QListViewItem*);
// virtual void toolButton114_clicked();


#endif // MANDVD_GLOBAL_H


