## Automatically adapted for numpy.oldnumeric Jul 23, 2007 by 

################################################################################
##
##
## Author: Sowjanya Karnati
##
##
################################################################################

#$Id: test_director.py,v 1.8 2007/07/24 17:30:44 vareille Exp $

#Contents Tested
#calling Director
#addActor:adding one,many
#functions:getLastFrame,getLastFrameWithChange,UpdateEndFrame
##Redraw
#checks redraw will not run in time gap between two actions.
#testing by starting actors action starting at frame 10, checks redraw doesn't run until 10
#checks redraw will not run if there is a time gap between prev actors end frame and next actors start frame
#testing customactor with two actors with same start frames.
#testing actors with time elapse
#testing redraw always runs after actors with redraw actions.
#tests interpolating properties:radii,color,camera height and width,quality,linewidth,pointwidth,opacity

import unittest
from scenario.actor import *
from scenario.interpolators import *
from scenario.director import *
from DejaVu import Viewer
from DejaVu.Spheres import Spheres
#from DejaVu.scenarioInterface.actor import ActionWithRedraw, RedrawActor
from DejaVu.IndexedPolylines import IndexedPolylines
from opengltk.OpenGL import GL
import numpy.oldnumeric as Numeric

class DirectorBaseTest(unittest.TestCase):

    def test_director_default(self):
        """testing calling director"""
        mydirector=Director()
        self.assertEqual(mydirector.actors,[])
        self.assertEqual(mydirector.currentFrame,0)
        self.assertEqual(mydirector.endFrame,50)
        self.assertEqual(mydirector.needsRedraw,False)
        self.assertEqual(mydirector.gui,None)
        self.assertEqual(mydirector.afterAnimation,[])
    
    #addActor
    def test_director_addActor_1(self):
        """testing addActor,adding one customactor"""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set=lambda actor,value:actor.object.Set(quality=radii)
        mycustomactor=CustomActor("sphere radius",sph,sph_set)
        mydirector.addActor(mycustomactor)
        self.assertEqual(len(mydirector.actors),1)
        vi.Exit()
       
    def test_director_addActor_morethan_one(self):
        """testing addActor,adding morethan one customactor"""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_r=lambda actor,value:actor.object.Set(quality=radii)
        sph_set_q=lambda actor,value:actor.object.Set(quality=quality)
        sph_set_o=lambda actor,value:actor.object.Set(quality=opacity)
        mycustomactor=CustomActor("sphere radius",sph,sph_set_r)
        mydirector.addActor(mycustomactor)
        mycustomactor1=CustomActor("sphere quality",sph,sph_set_q)
        mydirector.addActor(mycustomactor1)
        mycustomactor=CustomActor("sphere opacity",sph,sph_set_o)
        mydirector.addActor(mycustomactor)
        self.assertEqual(len(mydirector.actors),3)
        vi.Exit()
        
    def test_director_addActor_invalid_customactor(self):
        """testing addActor with inavlid actors"""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        mycustomactor="Hello World"
        self.assertRaises(AssertionError,mydirector.addActor,mycustomactor)    
        vi.Exit()
  
    #getLastFrame
    def test_director_getLastFrame(self):
        """testing function getLastFrame"""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_r=lambda actor,value:actor.object.Set(quality=radii)
        mycustomactor=CustomActor("sphere radius",sph,sph_set_r)
        myaction=Action(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([5,20]))
        mycustomactor.addAction(myaction)
        mydirector.addActor(mycustomactor)
        self.assertEqual(mydirector.getLastFrame(),10)
        vi.Exit()
        
    #getLastFrameWithChange
    def test_director_getLastFrameWithChange(self):
        """testing function getLastFrameWithChange"""

        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_r=lambda actor,value:actor.object.Set(quality=radii)
        mycustomactor=CustomActor("sphere radius",sph,sph_set_r)
        myaction=Action(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([5,20]))        
        mycustomactor.addAction(myaction)
        myaction1=Action(startFrame=20,endFrame=30,interpolator=KeyFrameInterpolator([25,40]))
        mycustomactor.addAction(myaction1)
        mydirector.addActor(mycustomactor)
        self.assertEqual(mydirector.getLastFrameWithChange(),30)
        vi.Exit()

    #updateEndFrame
    def test_director_updateEndFrame(self):
        """testing function updateEndFrame"""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_r=lambda actor,value:actor.object.Set(quality=radii)
        mycustomactor=CustomActor("sphere radius",sph,sph_set_r)
        myaction=Action(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([5,20]))        
        mycustomactor.addAction(myaction)
        mydirector.updateEndFrame(50)
        self.assertEqual(mydirector.endFrame,50)
        vi.Exit()
        
    #gotoFrame
    def XXtest_director_gotoFrame(self):
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        mycustomactor=CustomActor("sphere radius",sph,sph.Set,valueName="radii")
        myaction=Action(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([5,20]))        
        mycustomactor.addAction(myaction)
        mydirector.gotoFrame(8)
        self.assertEqual(mydirector.currentframe,8)
        vi.Exit()
    
    ##run()
    ##Testing with redraw
    def test_director_run_1(self):
        """testing adding customactor with one action"""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=5,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set=lambda actor,value: actor.object.Set(quality=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        myactor=Actor("quality",sph)
        mycustomactor2=CustomActor("sphere quality",sph,sph_set)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=200,interpolator=KeyFrameInterpolator([5,40]))
        mycustomactor2.addAction(myaction1)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        vi.Exit()
         
    def test_director_run_2(self):
        """testing by starting actors action starting at frame 10, checks redraw
        doesn't run until 10
        """
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set=lambda actor,value:actor.object.Set(quality=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("sphere quality",sph,sph_set)
        myaction1=ActionWithRedraw(startFrame=10,endFrame=20,interpolator=KeyFrameInterpolator([5,40]))
        mycustomactor2.addAction(myaction1)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        vi.Exit()
        
    def test_director_run_3(self):
        """testing customactor with two actions which have time gaps.checks redraw will not
        run in time gap"""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set=lambda actor,value:actor.object.Set(quality=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("sphere quality",sph,sph_set)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([5,10]))
        myaction2=ActionWithRedraw(startFrame=15,endFrame=20,interpolator=KeyFrameInterpolator([15,20]))
        mycustomactor2.addAction(myaction1)
        mycustomactor2.addAction(myaction2)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        vi.Exit()
        


    def test_director_run_4(self):
        """testing customactor with two actors with same start frames."""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_quality = lambda actor,value:actor.object.Set(quality=value)
        sph_set_opacity = lambda actor,value:actor.object.Set(opacity=value, inheritMaterial=0)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("sphere quality",sph,sph_set_quality)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([5,10]))
        #customactor3
        mycustomactor3=CustomActor("sphere opacity",sph,sph_set_opacity)
        myaction2=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([0,2]))
        mycustomactor2.addAction(myaction1)
        mycustomactor3.addAction(myaction2)
        mydirector.addActor(mycustomactor2)
        mydirector.addActor(mycustomactor3)
        mydirector.run()
        vi.Exit()



    def test_director_run_5(self):
        """testing customactor with two actors with diff start frames."""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_quality = lambda actor,value:actor.object.Set(quality=value)
        sph_set_opacity = lambda actor,value:actor.object.Set(opacity=value, inheritMaterial=0)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("sphere quality",sph,sph_set_quality)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([5,10]))
        #customactor3
        mycustomactor3=CustomActor("sphere opacity",sph,sph_set_opacity)
        myaction2=ActionWithRedraw(startFrame=5,endFrame=10,interpolator=KeyFrameInterpolator([0,2]))
        mycustomactor2.addAction(myaction1)
        mycustomactor3.addAction(myaction2)
        mydirector.addActor(mycustomactor2)
        mydirector.addActor(mycustomactor3)
        mydirector.run()
        vi.Exit()


    def test_director_run_6(self):
        """testing customactor with two actors with time gap,such that redraw
        shouldn't run in timegap"""
        mydirector=Director()
        vi = Viewer()
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_quality = lambda actor,value:actor.object.Set(quality=value)
        sph_set_opacity = lambda actor,value:actor.object.Set(opacity=value, inheritMaterial=0)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("sphere quality",sph,sph_set_quality)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([5,10]))
        #customactor3
        mycustomactor3=CustomActor("sphere opacity",sph,sph_set_opacity)
        myaction2=ActionWithRedraw(startFrame=15,endFrame=20,interpolator=KeyFrameInterpolator([0,2]))
        mycustomactor2.addAction(myaction1)
        mycustomactor3.addAction(myaction2)
        mydirector.addActor(mycustomactor2)
        mydirector.addActor(mycustomactor3)
        mydirector.run()
        vi.Exit()

    ##Testing interpolating geom and camera properties
    def XXtest_director_antialiased(self):    
        """tests interpolating antialiased"""
        mydirector=Director()
        vi = Viewer()
        points = ((0,0,0),(5,0,0))
        indices = ((0,1),)
        polylines= IndexedPolylines("box", vertices=points, faces=indices, visible=1)
        vi.AddObject(polylines)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("antialiased",polylines,polylines.Set,valueName="antialiased")
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([0,1]))
        mycustomactor2.addAction(myaction1)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        self.assertEqual(polylines.getState()['antialiased'],1)
        vi.Exit()
        
    def XXtest_director_visible(self):    
        """tests interpolating visible"""
        mydirector=Director()
        vi = Viewer()
        points = ((0,0,0),(5,0,0))
        indices = ((0,1),)
        polylines= IndexedPolylines("box", vertices=points, faces=indices, visible=1)
        vi.AddObject(polylines)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("visible",polylines,polylines.Set,valueName="visible")
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([0,1]))
        mycustomactor2.addAction(myaction1)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        self.assertEqual(polylines.getState()['visible'],1)
        vi.Exit()
        
    def test_director_linewidth(self):    
        """tests interpolating linewidth"""
        mydirector=Director()
        vi = Viewer()
        points = ((0,0,0),(10,0,0))
        indices = ((0,1),)
        polylines= IndexedPolylines("box", vertices=points, faces=indices, visible=1)
        vi.AddObject(polylines)
        lines_set_linewidth = lambda actor,value:actor.object.Set(lineWidth=value,inheritLineWidth=0)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("line width",polylines,lines_set_linewidth)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([0.10,10.0]))
        mycustomactor2.addAction(myaction1)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        self.assertEqual(polylines.getState()['lineWidth'],10)
        vi.Exit()
        
    def test_director_pointwidth(self):
        """tests interpolating point width"""
        mydirector=Director()
        vi = Viewer()
        points = ((0,0,0),(10,0,0))
        indices = ((0,1),)
        polylines= IndexedPolylines("box", vertices=points, faces=indices, visible=1)
        vi.AddObject(polylines)
        lines_set_pointwidth = lambda actor,value:actor.object.Set(pointWidth=value,inheritPointWidth=0)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("point width",polylines,lines_set_pointwidth)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([0.10,10.0]))
        mycustomactor2.addAction(myaction1)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        self.assertEqual(polylines.getState()['pointWidth'],10)
        vi.Exit()

    def test_director_radii(self):
        """tests interpolating radii"""
        mydirector=Director()
        vi = Viewer()    
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_radii=lambda actor,value:actor.object.Set(radii=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor1=CustomActor("sph radii",sph,sph_set_radii)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=100,interpolator=KeyFrameInterpolator([1.0,10.0]))
        mycustomactor1.addAction(myaction1)
        mydirector.addActor(mycustomactor1)
        mydirector.run()
        self.assertEqual(sph.radius,10.0)
        vi.Exit()   
        
    def test_director_camera_height_width(self):
        """tests interpolating camera height and width"""
        mydirector=Director()
        vi = Viewer()
        camera_set_height=lambda actor,value: actor.object.Set(height=value)
        camera_set_width=lambda actor,value: actor.object.Set(width=value)
        mycustomactor1=CustomActor("camera height",vi.currentCamera, camera_set_height)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=50,interpolator=KeyFrameInterpInt([150,300]))
        mycustomactor1.addAction(myaction1)
        mydirector.addActor(mycustomactor1)
        mycustomactor2=CustomActor("camera width",vi.currentCamera,camera_set_width)
        myaction2=ActionWithRedraw(startFrame=0,endFrame=50,interpolator=KeyFrameInterpInt([150,300]))
        mycustomactor2.addAction(myaction2)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        self.assertEqual(vi.currentCamera.height,300)
        self.assertEqual(vi.currentCamera.width,300)
        vi.Exit()
        
    def test_director_color(self):
        """tests interpolating color"""
        mydirector=Director()
        vi = Viewer()    
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_materials=lambda actor,value:actor.object.Set(materials=[value,],inheritMaterial=0)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor1=CustomActor("sph color",sph,sph_set_materials)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=200,interpolator=RGBAInterpolator(values=([0.0,0.0,1.0,1.0],[1.0,0.0,0.0,1.0])))
        mycustomactor1.addAction(myaction1)
        myaction2=ActionWithRedraw(startFrame=205,endFrame=300,interpolator=RGBAInterpolator(values=([1.0,0.0,0.0,1.0],[0.0,1.0,0.0,1.0])))
        mycustomactor1.addAction(myaction2)
        mydirector.addActor(mycustomactor1)
        mydirector.run()
        self.assertEqual(sph.materials[GL.GL_FRONT].getState()['diffuse'],[[0.0,1.0,0.0,1.0]])
        vi.Exit()

 
    def test_director_scale(self):
        """tests interpolating scale"""
        mydirector=Director()
        vi = Viewer()    
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=2.0, quality=30,
                  inheritLineWidth=0, 
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_scale=lambda actor,value:actor.object.Set(scale=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2   
        mycustomactor1=CustomActor("sph scale",sph,sph_set_scale)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=200,interpolator=ScaleInterpolator([(1.0,1.0,1.0),(10.0,10.0,10.0)]))
        mycustomactor1.addAction(myaction1) 
        mydirector.addActor(mycustomactor1)
        mydirector.run()
        #self.assertEqual(vi.currentObject.getState()['scale'],[3.0,3.0,3.0])
        vi.Exit()

    def test_director_pivot(self):
        """tests interpolating scale"""
        mydirector=Director()
        vi = Viewer()    
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=2.0, quality=30,
                  inheritLineWidth=0, 
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_pivot=lambda actor,value:actor.object.Set(pivot=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2   
        starts=Numeric.zeros(3,'f')
        ends = Numeric.array([1,1,1],'f')
        mycustomactor1=CustomActor("sph pivot",sph,sph_set_pivot)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=200,interpolator=TranslationInterpolator(values=[starts,ends]))
        mycustomactor1.addAction(myaction1) 
        mydirector.addActor(mycustomactor1)
        mydirector.run()
        self.assertEqual(sph.getState()['pivot'],[1.0,1.0,1.0])
        vi.Exit()
    
    
    def test_director_translation(self):
        """tests interpolating scale"""
        mydirector=Director()
        vi = Viewer()    
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=2.0, quality=30,
                  inheritLineWidth=0, 
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_translation=lambda actor,value:actor.object.Set(translation=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2   
        starts=Numeric.zeros(3,'f')
        ends = Numeric.array([1,1,1],'f')
        mycustomactor1=CustomActor("sph translation",sph,sph_set_translation)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=200,interpolator=TranslationInterpolator(values=[starts,ends]))
        mycustomactor1.addAction(myaction1) 
        mydirector.addActor(mycustomactor1)
        mydirector.run()
        vi.Exit()

    def test_director_rotation(self):
        from numpy.oldnumeric import array
        mydirector=Director()
        vi = Viewer()    
        points = ((0,0,0),(5,0,0),(0,5,0))
        indices = ((0,1),(0,2))
        polylines= IndexedPolylines("box", vertices=points, faces=indices, visible=1)
        vi.AddObject(polylines)
        lines_set_rotation = lambda actor,value:actor.object.Set(rotation=value)
        start_mat=Numeric.identity(4,'f') 
        z=[[0,-1,0,0],[1,0,0,0],[0,0,1,0],[0,0,0,1]]
        mat=array(z)
        s=Numeric.reshape(start_mat,(16,))
        e=Numeric.reshape(mat,(16,))
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2   
        starts=Numeric.zeros(3,'f')
        ends = Numeric.array([1,1,1],'f')
        mycustomactor1=CustomActor("polylines rotation",polylines,lines_set_rotation)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=200,interpolator=RotationInterpolator(values=[s,e]))
        mycustomactor1.addAction(myaction1) 
        mydirector.addActor(mycustomactor1)
        mydirector.run()
        vi.Exit()

    #Scissor
    def XXtest_director_scissor(self):    
        """tests interpolating visible"""
        mydirector=Director()
        vi = Viewer()
        points = ((0,0,0),(5,0,0))
        indices = ((0,1),)
        polylines= IndexedPolylines("box", vertices=points, faces=indices, visible=1)
        vi.AddObject(polylines)
        lines_set_scissor=lambda actor,value:actor.object.Set(scissor=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor2=CustomActor("scissor",polylines,lines_set_scissor)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=10,interpolator=KeyFrameInterpolator([0,1]))
        mycustomactor2.addAction(myaction1)
        mydirector.addActor(mycustomactor2)
        mydirector.run()
        self.assertEqual(polylines.getState()['visible'],1)
        vi.Exit()
        
    #Pre,Post Step Tests
    
    def Xtest_director_radii(self):
        """tests interpolating radii"""
        mydirector=Director()
        vi = Viewer()    
        sph = Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        sph_set_radii=lambda actor,value:actor.object.Set(radii=value)
        #customactor1
        mycustomactor=RedrawActor(vi)
        mydirector.addActor(mycustomactor)
        #customactor2
        mycustomactor1=CustomActor("sph radii",sph,sph_set_radii)
        myaction1=ActionWithRedraw(startFrame=0,endFrame=100,interpolator=KeyFrameInterpolator([1.0,10.0]),preStep_cb=(sph.Set,('quality'),{}))
        mycustomactor1.addAction(myaction1)
        mydirector.addActor(mycustomactor1)
        mydirector.run()
        self.assertEqual(sph.radius,10.0)
        vi.Exit()

    def Xtest_director_addActor(self):
        mydirector=Director()
        vi=Viewer()
        sph=Spheres('spheres', vertices =((0,0,0),(5.,0.,0.)),
                  materials=((.5,0,0),),
                  radii=5.0, quality=30,
                  inheritLineWidth=0, lineWidth=10,
                  inheritMaterial=False)
        vi.AddObject(sph)
        actor=RedrawActor(vi)
        mydirector.addActor(actor)        
        actor1=Actor("quality",sph)
        action1=ActionWithRedraw(startFrame=0,endFrame=200,interpolator=KeyFrameInterpolator([5,40]))
        actor1.addAction(action1)
        
        mydirector.addActor(actor1)
        mydirector.run()
        #self.assertEqual(mydirector.


if __name__ == '__main__':
    unittest.main()

