/*****************************************************************************/
/*                                                                           */
/*   UsefulMath: Some little math routines which dont fit anywhere else.     */
/*                                                                           */
/*   Copyright (C) The University of Texas at Austin                         */
/*                                                                           */
/*     Authors:     Vinay Siddavanahalli <skvinay@cs.utexas.edu>  2004-2005  */
/*     Authors:     Anthony Thane        <thanea@ices.utexas.edu> 2003-2003  */
/*                                                                           */
/*     Principal Investigator: Chandrajit Bajaj <bajaj@ices.utexas.edu>      */
/*                                                                           */
/*         Professor of Computer Sciences,                                   */
/*         Computational and Applied Mathematics Chair in Visualization,     */
/*         Director, Computational Visualization Center (CVC),               */
/*         Institute of Computational Engineering and Sciences (ICES)        */
/*         The University of Texas at Austin,                                */
/*         201 East 24th Street, ACES 2.324A,                                */
/*         1 University Station, C0200                                       */
/*         Austin, TX 78712-0027                                             */
/*         http://www.cs.utexas.edu/~bajaj                                   */
/*                                                                           */
/*         http://www.ices.utexas.edu/CVC                                    */
/*                                                                           */
/*   This library is free software; you can redistribute it and/or           */
/*   modify it under the terms of the GNU Lesser General Public              */
/*   License as published by the Free Software Foundation; either            */
/*   version 2.1 of the License, or (at your option) any later version.      */
/*   Specifically, this library is free for academic or personal non-profit  */
/*   use, with due acknowledgement. Any or all personal profit / industrial  */
/*   use needs to get a proper license approved from us.                     */
/*                                                                           */
/*   This library is distributed in the hope that it will be useful,         */
/*   but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       */
/*   Lesser General Public License for more details.                         */
/*                                                                           */
/*   You should have received a copy of the GNU Lesser General Public        */
/*   License along with this library; if not, write to the Free Software     */
/*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307    */
/*   USA                                                                     */
/*                                                                           */
/*****************************************************************************/

// Quaternion.h: interface for the Quaternion class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_QUATERNION_H__4A5485F3_5ADE_437D_A2C9_6D864A63C23B__INCLUDED_)
#define AFX_QUATERNION_H__4A5485F3_5ADE_437D_A2C9_6D864A63C23B__INCLUDED_

#include "Tuple.h"

namespace CCVOpenGLMath {

class Vector;
class Matrix;
class Ray;

class Quaternion : public Tuple  
{
public:
	Quaternion();
	virtual ~Quaternion();
	Quaternion(const Quaternion& copy);
	Quaternion& operator=(const Quaternion& copy);
	Quaternion(float w, float x, float y, float z);

	Quaternion& set(float w, float x, float y, float z);
	Quaternion& set(float* array);
	Quaternion& set(const Quaternion& copy);

	Quaternion operator*(const Quaternion& quat) const;
	Quaternion operator*(float scalar) const;
	Quaternion& operator*=(float scalar);
	Quaternion operator/(float scalar) const;
	Quaternion& operator/=(float scalar);

	Quaternion& preMultiply(const Quaternion& quat);
	Quaternion& postMultiply(const Quaternion& quat);
	Quaternion& rotate(float angle, float x, float y, float z);
	Quaternion& normalize();

	Quaternion conjugate() const;
	Quaternion inverse() const;
	float norm() const;

	Vector applyRotation(const Vector& vec) const;
	Ray applyRotation(const Ray& ray) const;
	Matrix buildMatrix() const;
	Quaternion power(double scalar);

	static Quaternion rotation(float angle, float x, float y, float z);
	static Quaternion rotation(float angle, const Vector& axis);

protected:
	explicit Quaternion(const Vector& vec);

};

};

#endif // !defined(AFX_QUATERNION_H__4A5485F3_5ADE_437D_A2C9_6D864A63C23B__INCLUDED_)
